% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.qr_code}
\alias{plot.qr_code}
\alias{plot.qr_logo}
\title{Plot the QR code
This function plots to QR code to the open device.}
\usage{
\method{plot}{qr_code}(x, col = c("white", "black"), y, ...)

\method{plot}{qr_logo}(x, col = c("white", "black"), y, ...)
}
\arguments{
\item{x}{the \code{qr_code} object}

\item{col}{Define the colours.
The first element refers to \code{FALSE} and the second \code{TRUE}.
Defaults to \code{c("white", "black")}.}

\item{y}{currently ignored}

\item{...}{currently ignored}
}
\description{
Plot the QR code
This function plots to QR code to the open device.
}
\examples{
qr <- qr_code("HELLO WORLD")
plot(qr)

# Test the QR code with the opencv package
if (requireNamespace("opencv")) {
  png("test.png")
  plot(qr)
  dev.off()
  opencv::ocv_qr_detect(opencv::ocv_read('test.png'))
  unlink("test.png")
}
}
\seealso{
\code{\link[opencv:qrcode]{opencv::ocv_qr_detect()}} for reading QR codes.

Other qr: 
\code{\link{coordinates}()},
\code{\link{generate_svg}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_event}()},
\code{\link{qr_wifi}()}

Other qr: 
\code{\link{coordinates}()},
\code{\link{generate_svg}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_event}()},
\code{\link{qr_wifi}()}
}
\author{
Thierry Onkelinx
}
\concept{qr}
