% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl_effects.R
\name{qtl_effects}
\alias{qtl_effects}
\alias{plot.qtlpoly.effects}
\title{QTL allele effect estimation}
\usage{
qtl_effects(ploidy = 6, fitted, pheno.col = NULL, verbose = TRUE)

\method{plot}{qtlpoly.effects}(x, pheno.col = NULL, p1 = "P1", p2 = "P2", ...)
}
\arguments{
\item{ploidy}{a numeric value of ploidy level of the cross (currently, only 4 or 6).}

\item{fitted}{a fitted multiple QTL model of class \code{qtlpoly.fitted}.}

\item{pheno.col}{a numeric vector with the phenotype column numbers to be plotted; if \code{NULL}, all phenotypes from \code{'fitted'} will be included.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.effects} to be plotted.}

\item{p1}{a character string with the first parent name, e.g. \code{"P1"} (default).}

\item{p2}{a character string with the second parent name, e.g. \code{"P2"} (default).}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.effects} which is a list of \code{results} for each containing the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{y.hat}{a vector with the predicted values.}

A \pkg{ggplot2} barplot with parental allele and allele combination effects.
}
\description{
Computes allele specific and allele combination (within-parent) heritable effects from multiple QTL models.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Fit model
  fitted.mod = fit_model(data, model=remim.mod, probs="joint", polygenes="none")

  # Estimate effects
  est.effects = qtl_effects(ploidy = 4, fitted = fitted.mod, pheno.col = 1)

  # Plot results
  plot(est.effects)
  }
  
}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
    
    Kempthorne O (1955) The correlation between relatives in a simple autotetraploid population, \emph{Genetics} 40: 168-174.
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{remim}}, \code{\link[qtlpoly]{fit_model}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
