% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_profile.R
\name{plot_profile}
\alias{plot_profile}
\title{Logarithm of \emph{P}-value (LOP) profile plots}
\usage{
plot_profile(
  data = data,
  model = model,
  pheno.col = NULL,
  sup.int = FALSE,
  main = NULL,
  legend = "bottom",
  ylim = NULL,
  grid = FALSE
)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{model}{an object of class \code{qtlpoly.profile} or \code{qtlpoly.remim}.}

\item{pheno.col}{a numeric vector with the phenotype column numbers to be plotted; if \code{NULL}, all phenotypes from \code{'data'} will be included.}

\item{sup.int}{if \code{TRUE}, support interval are shown as shaded areas; if \code{FALSE} (default), no support interval is show.}

\item{main}{a character string with the main title; if \code{NULL}, no title is shown.}

\item{legend}{legend position (either "bottom", "top", "left" or "right"); if \code{NULL}, no legend is shown.}

\item{ylim}{a numeric value pair supplying the limits of y-axis, e.g. c(0,10); if \code{NULL} (default), limits will be provided automatically.}

\item{grid}{if \code{TRUE}, profiles will be organized in rows (one per trait); if \code{FALSE} (default), profiles will appear superimposed. Only effective when plotting profiles from more than one trait.}
}
\value{
A \pkg{ggplot2} with the LOP profiles for each trait.
}
\description{
Plots profiled logarithm of score-based \emph{P}-values (LOP) from individual or combined traits.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Plot profile
  plot_profile(data = data, model = remim.mod, grid = FALSE)
  }

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{profile_qtl}},  \code{\link[qtlpoly]{remim}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
