% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSOSS.r
\name{QUALYPSOSS.ANOVA.step3}
\alias{QUALYPSOSS.ANOVA.step3}
\title{QUALYPSOSS.ANOVA.step3}
\usage{
QUALYPSOSS.ANOVA.step3(
  lOpt,
  lDim,
  yMCMC,
  RK,
  g.step1,
  lambda.step1,
  rho.step2,
  deltaRV.step2
)
}
\arguments{
\item{lOpt}{list of options, returned by \code{\link{QUALYPSOSS.check.option}}}

\item{lDim}{list of dimensions}

\item{yMCMC}{array \code{nMCMC} x \code{nFull} of climate change responses}

\item{RK}{large object containing the reproducing kernels, returned by \code{\link{QUALYPSOSS.get.RK}}}

\item{g.step1}{smooth effect estimates provided by \code{\link{QUALYPSOSS.ANOVA.step1}}}

\item{lambda.step1}{smooth parameter estimates provided by \code{\link{QUALYPSOSS.ANOVA.step1}}}

\item{rho.step2}{lag-1 autocorrelation estimate provided by \code{\link{QUALYPSOSS.ANOVA.step2}}}

\item{deltaRV.step2}{residual variance estimate provided by \code{\link{QUALYPSOSS.ANOVA.step2}}}
}
\value{
list containing diverse information aboutwith the following fields:
\itemize{
  \item \strong{g.MCMC}: Smooth effects \code{g}: array \code{n} x \code{nFull} x \code{K} where
  \code{nFull} is the number of possible combinations of predictors (discrete AND continuous),
  \item \strong{g.hat}: Smooth effects estimates: matrix \code{nFull} x \code{K} where
  \code{nFull} is the number of possible combinations of predictors (discrete AND continuous),
  \item \strong{Schwarz}: Schwarz criteria
  \item \strong{BIC}: BIC criteria
}
}
\description{
SSANOVA decomposition of the ensemble of climate change responses using a Bayesian approach.
In this second step, we infer deltaRV (variance of the residual errors) and phi (autocorrelation lag-1)
considering hetero-autocorrelated residual errors, conditionally to smooth effects inferred in \code{\link{QUALYPSOSS.ANOVA.step1}}
}
\author{
Guillaume Evin
}
