% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsyllable-methods.R
\name{nsyllable.tokens}
\alias{nsyllable.tokens}
\title{nsyllable methods for tokens}
\usage{
\method{nsyllable}{tokens}(
  x,
  syllable_dictionary = nsyllable::data_syllables_en,
  use.names = FALSE
)
}
\arguments{
\item{x}{character vector whose
syllables will be counted.  This will count all syllables in a character
vector without regard to separating tokens, so it is recommended that x be
individual terms.}

\item{syllable_dictionary}{optional named integer vector of syllable counts
where the names are lower case tokens.  This can be used to override the
language setting, when set to \code{NULL} (the default).  If a syllable
dictionary is supplied, this will override the \code{language} argument.}

\item{use.names}{logical; if \code{TRUE}, assign the tokens as the names of the
syllable count vector}
}
\description{
Extends \code{nsyllable()} methods for \link{tokens} objects.
}
\examples{
\dontshow{
library("nsyllable")
txt <- c(one = "super freakily yes",
         two = "merrily all go aerodynamic")
toks <- quanteda::tokens(txt)
nsyllable(toks)
}
}
\keyword{internal}
