% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{change}
\alias{change}
\title{Change Score from a Numeric Vector}
\usage{
change(x, n, undefined = NA)
}
\arguments{
\item{x}{numeric vector.}

\item{n}{integer vector with length 1. Specifies how the change score is
calculated. If \code{n} is positive, then the change score is calculated
from lead - original; if \code{n} is negative, then the change score is
calculated from original - lag. The magnitude of \code{n} determines how
many elements are shifted for the lead/lag within the calculation. If
\code{n} is zero, then \code{change} simply returns a vector or zeros. See
details of \code{\link{shift}}.}

\item{undefined}{atomic vector with length 1 (probably makes sense to be the
same typeof as \code{x}). Specifies what to insert for undefined values
after the shifting takes place. See details of \code{\link{shift}}.}
}
\value{
an atomic vector of the same length as \code{x} that is the change
  score. If \code{x} and \code{undefined} are different typeofs, then the
  return will be coerced to the most complex typeof (i.e., complex to simple:
  character, double, integer, logical).
}
\description{
\code{change} creates a change score (aka difference score) from a numeric
vector. It is assumed that the vector is already sorted by time such that the
first element is earliest in time and the last element is the latest in time.
}
\details{
It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shift} tries to circumvent this
issue by a call to \code{round} within \code{shift} if \code{n} is not an
integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shift} truncates rather than rounds.
See details of \code{\link{shift}}.
}
\examples{
change(x = attitude[[1]], n = -1L) # use L to prevent problems with floating point numbers
change(x = attitude[[1]], n = -2L) # can specify any integer up to the length of `x`
change(x = attitude[[1]], n = +1L) # can specify negative or positive integers
change(x = attitude[[1]], n = +2L, undefined = -999) # user-specified indefined value
change(x = attitude[[1]], n = -2L, undefined = -999) # user-specified indefined value
change(x = attitude[[1]], n = 0L) # returns a vector of zeros
\dontrun{
change(x = setNames(object = letters, nm = LETTERS), n = 3L) # character vector returns an error
}
}
\seealso{
\code{\link{changes}}
   \code{\link{change_by}}
   \code{\link{changes_by}}
   \code{\link{shift}}
}
