% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_queuefunctions.R
\name{wait_step}
\alias{wait_step}
\title{Compute maximum time for each row from two vectors of arrival times.}
\usage{
wait_step(arrivals, service)
}
\arguments{
\item{arrivals}{Either a numeric vector or an object of class \code{queue_list}. It represents the arrival times.}

\item{service}{A vector of times which represent the arrival times of the second type
of customers. The ordering of this vector should have the same ordering as \code{arrivals}.}
}
\value{
The maximum time from two vectors of arrival times.
}
\description{
Compute maximum time for each row from two vectors of arrival times.
}
\details{
A good real-world example of this is finding the departure times for passengers
 after they pick up their bags from the baggage carosel. The time at which they leave is
 the maximum of the passenger and bag arrival times.
}
\examples{
set.seed(500)
arrivals <- rlnorm(100, meanlog = 4)
service <- rlnorm(100)

#Airport example ------------------------

# Create a number of bags for each of 100 customers
bags <- rpois(100,1)

# Create a bags dataframe, with each bag associated with one customer.
bags.df <- data.frame(BagID = 1:sum(bags),
   ID = rep(1:100, bags), times = rlnorm(sum(bags), meanlog = 2))

# Create a function which will return the maximum time from each customer's set of bags.

reduce_bags <- function(bagdataset, number_of_passengers){
   ID = NULL
   times = NULL

   zerobags <- data.frame(BagID = NA, ID = c(1:number_of_passengers), times = 0)
   reduced_df <- as.data.frame(dplyr::summarise(dplyr::group_by(
   rbind(bagdataset, zerobags), ID), n = max(times, 0)))
   ord <- order(reduced_df$ID)
   reduced_df <- reduced_df[order(ord),]
   names(reduced_df) <- c("ID", "times")
   return(reduced_df)
}


arrivals2 <- reduce_bags(bags.df, 100)$times

# Find the time when customers can leave with their bags.
wait_step(arrivals = arrivals, service = arrivals2)
}
\seealso{
\code{\link{lag_step}}, \code{\link{queue_step}}.
}

