% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitNmix.R
\name{fitNmix}
\alias{fitNmix}
\title{Fit Asymptotic N-mixture Model}
\usage{
fitNmix(
  nit,
  K = NULL,
  starts = NULL,
  l_s_c = NULL,
  g_s_c = NULL,
  g_t_c = NULL,
  o_s_c = NULL,
  o_t_c = NULL,
  p_s_c = NULL,
  p_t_c = NULL,
  SMALL_a_CORRECTION = FALSE,
  VERBOSE = FALSE,
  outfile = NULL,
  method = "BFGS",
  ...
)
}
\arguments{
\item{nit}{Matrix of counts data. Rows represent sites, columns represent sampling occasions. Note that if the data is a vector, then it will be converted to a matrix with a single row.}

\item{K}{Upper bound on summations in the likelihood function. K should be chosen large enough that the negative log likelihood function is stable (unchanging as K increases). If K=NULL, K=5*max(nit) will be used as default. Default: NULL}

\item{starts}{Either NULL for default starting values, or a vector of parameter values: \code{c(log(lambda), log(gamma), logit(omega), logit(pdet))}. Note that the parameter vector will need to be longer by one for each parameter coefficient if covariate values are supplied. The order of coefficients is: \code{c(lambda, l_s_c, gamma, g_s_c, g_t_c, omega, o_s_c, o_t_c, pdet, p_s_c, p_t_c)}}

\item{l_s_c}{List of lambda site covariates, Default: NULL}

\item{g_s_c}{List of gamma site covariates, Default: NULL}

\item{g_t_c}{List of gamma time covariates, Default: NULL}

\item{o_s_c}{List of omega site covariates, Default: NULL}

\item{o_t_c}{List of omega time covariates, Default: NULL}

\item{p_s_c}{List of pdet site covariates, Default: NULL}

\item{p_t_c}{List of pdet time covariates, Default: NULL}

\item{SMALL_a_CORRECTION}{If TRUE will apply the small a correction when calculating the transition probability matrix, Default: FALSE}

\item{VERBOSE}{If TRUE, will print additional information during model fitting, Default: FALSE}

\item{outfile}{Location of csv file to write/append parameter values, can be used to checkpoint long running model fits. Default: NULL}

\item{method}{Optimization method, passed to optim function, options include: "BFGS", "Nelder-Mead", "CG". Default: "BFGS"}

\item{...}{Additional arguments passed to the optimization function optim. For example: \code{control = list(trace=1, REPORT=1, reltol=1e-10)}}
}
\value{
Returns the fitted model object.
}
\description{
Fit an open population N-mixture model using the asymptotic approximation. The four parameters are mean initial site abundance lambda, mean recruitments gamma, survival probability omega, and probability of detection pdet. Parameters can be made to vary over sites and over times by including parameter covariates. Note that this function is essentially a wrapper for optim acting on the nll function.
}
\examples{
nit = matrix(c(1,1,0,1,1), nrow=1) # observations for 1 site, 5 sampling occassions
model1 = fitNmix(nit, K=10)        # fit the model with population upper bound K=10
}
