% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{find_lg_benchmark}
\alias{find_lg_benchmark}
\title{Compute a benchmark value to remove long edges}
\usage{
find_lg_benchmark(distance_edges, distance_col)
}
\arguments{
\item{distance_edges}{The data frame containing the distances.}

\item{distance_col}{The name of the column containing the distances.}
}
\value{
The benchmark value, which is the first largest difference in the distance column.
}
\description{
This function finds the benchmark value to remove long edges based on
the differences in a distance column.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
df_bin_centroids <- extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)
tr1_object <- tri_bin_centroids(hex_df = df_bin_centroids, x = "c_x", y = "c_y")
tr_from_to_df <- gen_edges(tri_object = tr1_object)
distance_df <- cal_2d_dist(tr_coord_df = tr_from_to_df, start_x = "x_from",
start_y = "y_from", end_x = "x_to", end_y = "y_to",
select_vars = c("from", "to", "distance"))
find_lg_benchmark(distance_edges = distance_df, distance_col = "distance")

}
