% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_plots.R
\name{comb_all_data_model_error}
\alias{comb_all_data_model_error}
\title{Create a tibble with averaged high-dimensional data and
high-dimensional data, non-linear dimension reduction data, model error data}
\usage{
comb_all_data_model_error(
  highd_data,
  nldr_data,
  model_highd,
  model_2d,
  error_data
)
}
\arguments{
\item{highd_data}{A tibble that contains the high-dimensional data.}

\item{nldr_data}{A tibble that contains the non-linear dimension reduction data.}

\item{model_highd}{A tibble that contains the high-dimensional coordinates of bin centroids.}

\item{model_2d}{A tibble that contains hexagonal bin centroids in 2-D.}

\item{error_data}{A tibble that contains high-dimensional model error.}
}
\value{
A tibble with the average values of the high-dimensional data within
each hexagonal bin and high-dimensional data, non-linear dimension reduction data, model error.
}
\description{
This function combine the average values of high-dimensional data within each
hexagonal bin and high-dimensional data, non-linear dimension reduction data,
model error data.
}
\examples{
model_error <- augment(highd_data = scurve, model_highd = scurve_model_obj$model_highd,
model_2d = scurve_model_obj$model_2d)
comb_all_data_model_error(highd_data = scurve, nldr_data = scurve_umap,
model_highd = scurve_model_obj$model_highd, model_2d = scurve_model_obj$model_2d,
error_data = model_error)

}
