% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{logit}
\alias{logit}
\alias{invlogit}
\title{logit and inverse logit functions}
\usage{
logit(x)

invlogit(x)
}
\arguments{
\item{x}{a numeric vector}
}
\description{
transform \code{x} either via the logit, or inverse logit.
}
\details{
The logit and inverse logit functions are part of R via the
logistic distribution functions in the stats package.
Quoting from the documentation for the logistic distribution

"\code{qlogis(p)} is the same as the \code{logit} function, \code{logit(p) =
log(p/1-p)}, and \code{plogis(x)} has consequently been called the 'inverse
logit'."

See the examples for benchmarking these functions.  The \code{logit} and
\code{invlogit} functions are faster than the \code{qlogis} and \code{plogis}
functions.
}
\examples{
library(rbenchmark)

# compare logit to qlogis
p <- runif(1e5)
identical(logit(p), qlogis(p))

\dontrun{
rbenchmark::benchmark(logit(p), qlogis(p))
}

# compare invlogit to plogis
x <- runif(1e5, -1000, 1000)
identical(invlogit(x), plogis(x))

\dontrun{
rbenchmark::benchmark(invlogit(x), plogis(x))
}

}
\seealso{
\code{\link[stats:Logistic]{qlogis}}
}
