% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qkmplot.R
\name{qkmplot}
\alias{qkmplot}
\alias{qkmplot_bulid_data_frame}
\title{Kaplan-Meier Plot}
\usage{
qkmplot(x, conf_int = FALSE, ...)

qkmplot_bulid_data_frame(x)
}
\arguments{
\item{x}{object}

\item{conf_int}{logical if TRUE show the CI}

\item{...}{Other arguments passed to survival::plot.survfit}
}
\value{
a ggplot.
}
\description{
A ggplot2 version of a Kaplan-Meier Plot
}
\details{
Functions to build, explicitly or implicitly, data.frames and then creating a
ggplot2 KM plot.
}
\examples{
# create a survfit object
require(survival)
leukemia.surv <- survival::survfit(survival::Surv(time, status) ~ x, data = survival::aml)

qkmplot(leukemia.surv, conf_int = TRUE)

}
\seealso{
\code{vignette("qwraps2-graphics", package = "qwraps2")} for
additional examples.
}
