% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/rd.R, R/set.R
\name{m_add_style}
\alias{m_add_style}
\alias{m_style}
\alias{m_set_style}
\title{Set or set style properties to all selected atoms}
\usage{
m_add_style(id, sel = list(), style = list())

m_set_style(id, sel = list(), style = list())
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{sel}{Atom selection specification}

\item{style}{Style spec to apply to specified atoms}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Set or set style properties to all selected atoms
}
\examples{
library(r3dmol)

# Add style to model
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_add_style(style = list(cartoon = list())) \%>\%
  m_zoom_to()

# Set style to model
r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_set_style(style = list(cartoon = list())) \%>\%
  m_set_style(
    sel = list(chain = "A"),
    style = list(stick = list(
      radius = 0.5,
      colorscheme = "magentaCarbon"
    ))
  ) \%>\%
  m_zoom_to()
}
