% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ChartCursor.R, R/ChartCursor_setters.R
\docType{methods}
\name{initialize,ChartCursor-method}
\alias{chartCursor}
\alias{initialize,ChartCursor-method}
\alias{setOneBalloonOnly}
\alias{setOneBalloonOnly,ChartCursor,logical-method}
\alias{setValueLineAxis}
\alias{setValueLineAxis,ChartCursor,ValueAxisOrCharacterOrMissing-method}
\title{Initialize a ChartCursor}
\usage{
\S4method{initialize}{ChartCursor}(.Object, oneBalloonOnly, valueLineAxis, ...)

chartCursor(animationDuration = 0.3, oneBalloonOnly, valueLineAxis, ...)

setOneBalloonOnly(.Object, oneBalloonOnly)

\S4method{setOneBalloonOnly}{ChartCursor,logical}(.Object, oneBalloonOnly)

setValueLineAxis(.Object, valueLineAxis = NULL, ...)

\S4method{setValueLineAxis}{ChartCursor,ValueAxisOrCharacterOrMissing}(.Object,
  valueLineAxis = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{ChartCursor}.}

\item{oneBalloonOnly}{\code{logical}.
If this is set to TRUE, border color instead of background color will be changed when
user rolls-over the slice, graph, etc.}

\item{valueLineAxis}{\linkS4class{ValueAxis}.
If you set valueLineBalloonEnabled to true,
but you have more than one axis, you can use this property
to indicate which axis should display balloon.}

\item{...}{other properties.
See \url{http://docs.amcharts.com/3/javascriptcharts/ChartCursor}}

\item{animationDuration}{\code{numeric}, duration of animation of a line, in seconds.}
}
\value{
(updated) .Object of class \linkS4class{ChartCursor}.
}
\description{
Initialize a ChartCursor
}
\section{Functions}{
\itemize{
\item \code{chartCursor}: 
}}
\examples{
new("ChartCursor", oneBalloonOnly = TRUE)
chartCursor()
chartCursor(oneBalloonOnly = TRUE)
setOneBalloonOnly(.Object = chartCursor(), oneBalloonOnly = TRUE)
setValueLineAxis(.Object = chartCursor(), id = "valueAxis1",
                 title = "Hello !", axisTitleOffset = 12)
# equivalent to:
valueLineAxis_obj <- valueAxis(id = "valueAxis1", title = "Hello !", axisTitleOffset = 12)
setValueLineAxis(.Object = chartCursor(), valueLineAxis  = valueLineAxis_obj)
# or iff 'valueLineAxis_obj' has already been added to the chart:
setValueLineAxis(.Object = chartCursor(), valueLineAxis  = "valueAxis1")
}

