% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AmChart_getSet.R
\docType{methods}
\name{addSegment}
\alias{addSegment}
\alias{addSegment,AmChart,numeric-method}
\title{Add a segment to a category of AmChart}
\usage{
addSegment(.Object, categoryIDs, sgts)

\S4method{addSegment}{AmChart,numeric}(.Object, categoryIDs, sgts)
}
\arguments{
\item{.Object}{object of class \code{\linkS4class{AmChart}}}

\item{categoryIDs}{Object of class \code{numeric}.}

\item{sgts}{Object of class \code{data.frame}
( or \code{list} of \code{data.frame} for multiple add ).}
}
\value{
The updated object of class \code{\linkS4class{AmChart}}.
}
\description{
Add a segment to a category of AmChart
}
\details{
Use this methode in case of an AmChart.
}
\section{Methods (by class)}{
\itemize{
\item \code{.Object = AmChart,categoryIDs = numeric}: 
}}
\examples{
library(pipeR)
amGanttChart(segmentsField = "segments"
) \%>>\% setDataProvider(data.frame(category = c( "John", "Julia"))
) \%>>\% addSegment(1, data.frame(start = 7, duration = 2:3, task = c("Task #1", "Task #2"))
) \%>>\% addSegment(2, data.frame(start = 10, duration = 2:3, task = c("Task #1", "Task #2")))

ls <- list( data.frame(start = 7, duration = 2:3, task = c("Task #1", "Task #2")),
data.frame(start = 10, duration = 2:3, task = c("Task #1", "Task #2")))
amGanttChart(segmentsField = "segments"
) \%>>\% setDataProvider(data.frame(category = c( "John", "Julia"))
) \%>>\% addSegment( 1:2,  ls)
}
\seealso{
\code{\linkS4class{AmChart}} S4 class

Other AmChart methods: \code{\link{addArrow}},
  \code{\link{addArrow,AmChart-method}};
  \code{\link{addAxe}},
  \code{\link{addAxe,AmChart-method}};
  \code{\link{addGraph}},
  \code{\link{addGraph,AmChart-method}};
  \code{\link{addGuide,AmChart-method}};
  \code{\link{addLabel}},
  \code{\link{addLabel,AmChart-method}};
  \code{\link{addSubData}},
  \code{\link{addSubData,AmChart,numeric,data.frame-method}};
  \code{\link{addTitle}},
  \code{\link{addTitle,AmChart-method}};
  \code{\link{addTrendLine}},
  \code{\link{addTrendLine,AmChart-method}};
  \code{\link{addValueAxes}},
  \code{\link{addValueAxes,AmChart-method}};
  \code{\link{setAllLabels}},
  \code{\link{setAllLabels,AmChart,list-method}};
  \code{\link{setArrows}},
  \code{\link{setArrows,AmChart-method}};
  \code{\link{setAxes}},
  \code{\link{setAxes,AmChart,list-method}};
  \code{\link{setBalloon}},
  \code{\link{setBalloon,AmChart-method}};
  \code{\link{setCategoryAxis}},
  \code{\link{setCategoryAxis,AmChart-method}};
  \code{\link{setCategoryField}},
  \code{\link{setCategoryField,AmChart,character-method}};
  \code{\link{setChartCursor}},
  \code{\link{setChartCursor,AmChart-method}};
  \code{\link{setChartScrollbar}},
  \code{\link{setChartScrollbar,AmChart-method}};
  \code{\link{setCreditsPosition}},
  \code{\link{setCreditsPosition,AmChart,character-method}};
  \code{\link{setDataProvider,AmChart,data.frame-method}};
  \code{\link{setExport}},
  \code{\link{setExport,AmChart-method}};
  \code{\link{setGraph,AmChart-method}};
  \code{\link{setGraphs}},
  \code{\link{setGraphs,AmChart,list-method}};
  \code{\link{setGuides}},
  \code{\link{setGuides,AmChart,list-method}};
  \code{\link{setLegend}},
  \code{\link{setLegend,AmChart-method}};
  \code{\link{setSubChartProperties}},
  \code{\link{setSubChartProperties,AmChart-method}};
  \code{\link{setTitles}},
  \code{\link{setTitles,AmChart,list-method}};
  \code{\link{setTrendLines}},
  \code{\link{setTrendLines,AmChart,list-method}};
  \code{\link{setValueAxes}},
  \code{\link{setValueAxes,AmChart,list-method}};
  \code{\link{setValueAxis,AmChart-method}}
}

