% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amWind.R
\name{amWind}
\alias{amWind}
\title{Plotting wind}
\usage{
amWind(data, col = NULL, backTransparency = 0.5, ...)
}
\arguments{
\item{data}{\code{data.frame}, a dataframe which columns are series of values, 
from weakest wind (first column) to stronger wind (last column). See \link{data_wind}.}

\item{col}{\code{character}, color(s) of serie(s) hexadecimal like "#00FF00".}

\item{backTransparency}{\code{numeric}, background transparency, between 0 and 1.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amWind computes a windplot of the given data values.
}
\examples{

\dontrun{
data("data_wind")
amWind(data_wind)


# Other examples available which can be time consuming depending on your configuration.

# Change color
amWind(data = data_wind, col = "#0404B4")
amWind(data = data_wind, col = c("#0404B4","#01DF01","#FFBF00"))

# Change backTransparency
amWind(data = data_wind, col = c("#0404B4","#01DF01","#FFBF00"), backTransparency = 0.1)
amWind(data = data_wind, col = c("#0404B4","#01DF01","#FFBF00"), backTransparency = 1)
amWind(data = data_wind, col = c("#0404B4","#01DF01","#FFBF00"), backTransparency = c(0.1, 0.1, 1))

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
