% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel1BGeo.R
\name{clipLevel1BGeo}
\alias{clipLevel1BGeo}
\title{Clip GEDI Full Waveform Geolocations by Coordinates}
\usage{
clipLevel1BGeo(level1BGeo, xmin, xmax, ymin, ymax)
}
\arguments{
\item{level1BGeo}{A GEDI Level1b object (output of \code{\link[rGEDI:readLevel1B]{readLevel1B}} function).
An S4 object of class "gedi.level1b".}

\item{xmin}{Numeric. West longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{xmax}{Numeric. East longitude (x) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymin}{Numeric. South latitude (y) coordinate of the bounding rectangle, in decimal degrees.}

\item{ymax}{Numeric. North latitude (y) coordinate of the bounding rectangle, in decimal degrees.}
}
\value{
Returns an S4 object of class \code{\link[data.table:data.table]{data.table-class}}.
}
\description{
This function clips GEDI level1B extracted geolocation (level1BGeo)
data a within given bounding coordinates
}
\examples{
# Specifying the path to GEDI level1B data (zip file)
level1B_fp_zip <- system.file("extdata",
                  "GEDI01_B_2019108080338_O01964_T05337_02_003_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level1B data
level1Bpath <- unzip(level1B_fp_zip,exdir = dirname(level1B_fp_zip))

# Reading GEDI level1B data (h5 file)
level1b<-readLevel1B(level1Bpath=level1Bpath)

# Extracting GEDI Full Waveform Geolocations
level1bGeo<-getLevel1BGeo(level1b)

# Bounding rectangle coordinates
xmin = -44.15036
xmax = -44.10066
ymin = -13.75831
ymax = -13.71244

# Clipping GEDI Full Waveform Geolocations by boundary box extent
level1bGeo_clip <- clipLevel1BGeo(level1bGeo,xmin, xmax, ymin, ymax)

library(leaflet)
leaflet() \%>\%
 addCircleMarkers(level1bGeo_clip$longitude_bin0,
                  level1bGeo_clip$latitude_bin0,
                  radius = 1,
                  opacity = 1,
                  color = "red")  \%>\%
 addScaleBar(options = list(imperial = FALSE)) \%>\%
 addProviderTiles(providers$Esri.WorldImagery)

close(level1b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi01_bv001/
}
