% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.gedi.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,gedi.fullwaveform,missing-method}
\alias{plot,gedi.level1bSim,missing-method}
\title{Plot GEDI* object}
\usage{
plot(x, y, ...)

\S4method{plot}{gedi.fullwaveform,missing}(x, relative = FALSE,
  polygon = FALSE, ...)

\S4method{plot}{gedi.level1bSim,missing}(x, relative = FALSE,
  polygon = FALSE, method = "RXWAVEINT", ...)
}
\arguments{
\item{x}{An object of class "gedi.fullwaveform". (output of \code{\link[rGEDI:getLevel1BWF]{getLevel1BWF}} function)}

\item{y}{not used (inherited from R base)}

\item{...}{will be passed to the main plot}

\item{relative}{if TRUE, the Waveform Amplitude will be showed in percentage (\%)}

\item{polygon}{if TRUE, the polygon will be added to the plot}

\item{method}{methods used for simulating the GEDI full-waveform ("RXWAVEINT","RXWAVEINT" or "RXWAVEINT"). Default is "RXWAVECOUNT".}
}
\value{
No return value
}
\description{
For gedi.fullwaveform: will plot the full waveform\cr\cr

for gedi.level1bSim: will plot the simulated waveform
}
\examples{
# Specifying the path to GEDI level1B data (zip file)
level1B_fp_zip <- system.file("extdata",
                  "GEDI01_B_2019108080338_O01964_T05337_02_003_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level1B data
level1Bpath <- unzip(level1B_fp_zip,exdir = dirname(level1B_fp_zip))

# Reading GEDI level1B data (h5 file)
level1b<-readLevel1B(level1Bpath=level1Bpath)

# Extracting GEDI Full-Waveform
wf <- getLevel1BWF(level1b, shot_number="19640521100108408")

# Plotting GEDI Full-waveform
oldpar<-par()
par(mfrow = c(1,2), cex.axis = 1.5)
plot(wf, relative=FALSE, polygon=TRUE, type="l", lwd=2, col="forestgreen",
xlab="", ylab="Elevation (m)")

plot(wf, relative=TRUE, polygon=TRUE, type="l", lwd=2, col="forestgreen",
xlab="Waveform Amplitude (\%)", ylab="Elevation (m)")

par(oldpar) 
close(level1b)
outdir <- tempdir()

zipfile_amazon <- system.file("extdata", "Amazon.zip", package="rGEDI")
zipfile_Savanna <- system.file("extdata", "Savanna.zip", package="rGEDI")

lasfile_amazon <- unzip(zipfile_amazon,exdir=outdir)
lasfile_Savanna <- unzip(zipfile_Savanna,exdir=outdir)

# Reading and plot ALS file
libsAvailable = require(lidR) && require(plot3D)
if (libsAvailable) {
las_amazon<-readLAS(lasfile_amazon)
las_Savanna<-readLAS(lasfile_Savanna)

# Extracting plot center geolocations
xcenter_amazon = mean(las_amazon@bbox[1,])
ycenter_amazon = mean(las_amazon@bbox[2,])
xcenter_Savanna = mean(las_Savanna@bbox[1,])
ycenter_Savanna = mean(las_Savanna@bbox[2,])

# Simulating GEDI full-waveform
wf_amazon<-gediWFSimulator(
                          input=lasfile_amazon,
                          output=file.path(
                                        outdir,
                                        "gediWF_amazon_simulation.h5"
                                        ),
                          coords = c(xcenter_amazon, ycenter_amazon))
wf_Savanna<-gediWFSimulator(
                            input=lasfile_Savanna,
                            output=file.path(
                                          outdir,
                                          "gediWF_Savanna_simulation.h5"
                                          ),
                            coords = c(xcenter_Savanna, ycenter_Savanna))
# Plot Full-waveform
par(mfrow=c(2,2), mar=c(4,4,0,0), oma=c(0,0,1,1),cex.axis = 1.2)
scatter3D(
         las_amazon@data$X,
         las_amazon@data$Y,
         las_amazon@data$Z,
         pch = 16, colkey = FALSE, main="",
         cex = 0.5, bty = "u", col.panel ="gray90",
         phi = 30, alpha=1, theta=45, col.grid = "gray50",
         xlab="UTM Easting (m)", ylab="UTM Northing (m)", zlab="Elevation (m)"
         )

plot(wf_amazon, relative=TRUE, polygon=TRUE, type="l", lwd=2, col="forestgreen",
    xlab="", ylab="Elevation (m)", ylim=c(90,140))
grid()
scatter3D(
         las_Savanna@data$X,las_Savanna@data$Y,las_Savanna@data$Z,
         pch = 16,colkey = FALSE, main="",
         cex = 0.5,bty = "u",col.panel ="gray90",
         phi = 30,alpha=1,theta=45,col.grid = "gray50",
         xlab="UTM Easting (m)", ylab="UTM Northing (m)", zlab="Elevation (m)"
         )

plot(wf_Savanna, relative=TRUE, polygon=TRUE, type="l", lwd=2, col="green",
    xlab="Waveform Amplitude (\%)", ylab="Elevation (m)", ylim=c(815,835))
grid()

close(wf_amazon)
close(wf_Savanna)
}
}
