% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipLevel1B.R
\name{clipLevel1BGeometry}
\alias{clipLevel1BGeometry}
\title{Clip GEDI Level1B data by geometry}
\usage{
clipLevel1BGeometry(level1b, polygon_spdf, output = "", split_by = NULL)
}
\arguments{
\item{level1b}{A GEDI Level1B object (output of \code{\link[rGEDI:readLevel1B]{readLevel1B}} function).
An S4 object of class "gedi.level1b".}

\item{polygon_spdf}{Polygon. An object of class \code{\link[sp]{SpatialPolygonsDataFrame-class}},
which can be loaded as an ESRI shapefile using \code{\link[raster:shapefile]{raster::shapefile()}} function in the \emph{raster} package.}

\item{output}{Optional character path where to save the new hdf5file. The default stores a temporary file only.}

\item{split_by}{Polygon id. If defined, GEDI data will be clipped by each polygon using the attribute specified by \code{split_by} from the attribute table.}
}
\value{
Returns a list of S4 object of class "gedi.level1b" containing clipped GEDI Level1B data.
}
\description{
This function clips GEDI Level1B (geolocated waveforms) data within a given bounding geometry
}
\examples{
\donttest{
outdir = tempdir()

# Specifying the path to GEDI level1B data (zip file)
level1B_fp_zip <- system.file("extdata",
                  "GEDI01_B_2019108080338_O01964_T05337_02_003_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level1B data
level1Bpath <- unzip(level1B_fp_zip,exdir = dirname(level1B_fp_zip))

# Reading GEDI level1B data (h5 file)
level1b<-readLevel1B(level1Bpath=level1Bpath)

# Specifying the path to shapefile
polygon_filepath <- system.file("extdata", "stands_cerrado.shp", package="rGEDI")

# Reading shapefile as SpatialPolygonsDataFrame object
library(raster)
polygon_spdf<-shapefile(polygon_filepath)

# Spepecifing output file and path
output<-file.path(outdir,"GEDI01_B_2019108080338_O01964_T05337_02_003_01_clip")

# clipping GEDI Level1B data by extent boundary box
level1b_clip <- clipLevel1BGeometry(level1b, polygon_spdf = polygon_spdf,
                                   output=output,
                                   split_by="id")

close(level1b)
lapply(level1b_clip, close)
}
}
