% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rGroovy.R
\docType{package}
\name{rGroovy}
\alias{rGroovy}
\alias{rGroovy-package}
\title{Groovy Scripting Language Integration}
\description{
Functions that integrate the Groovy scripting language with the R Project for Statistical Computing.
}
\details{


From \href{http://en.wikipedia.org/wiki/Groovy_(programming_language)}{Wikipedia}:

"Groovy is an object-oriented programming language for the Java platform. It is a dynamic language with features
similar to those of Python, Ruby, Perl, and Smalltalk. It can be used as a scripting language for the Java Platform,
is dynamically compiled to Java Virtual Machine (JVM) bytecode, and interoperates with other Java code and
libraries."
}
\examples{
\dontrun{
#
# Installation Example
#
# Since this package does not ship with Groovy the user needs to specify the Groovy jars prior
# to using the package -- here's an example how this is accomplished:
#
groovyJars <- list (
    "C:/Temp/groovy.jars/groovy-2.4.5-indy.jar",
    # OTHER JAR FILES...
)

options(GROOVY_JARS=groovyJars)

library(rGroovy)

Execute (groovyScript="print 'Hello world!'")
}
}
\seealso{
\href{http://groovy.codehaus.org/}{Groovy}

\href{http://www.groovy-lang.org/indy.html}{Invoke Dynamic}
}

