% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_artefact.R
\name{CCFartefacts}
\alias{CCFartefacts}
\title{Detection of potential artefacts in CCF results.}
\usage{
CCFartefacts(mea, threshold, delta = 1, duration = attributes(mea)$ccf$inc)
}
\arguments{
\item{mea}{an object of class \code{MEA} or a list of \code{MEA} objects (see function \code{\link{readMEA}})}

\item{threshold}{A single numeric value specifying the absolute correlation value above (and below) which a window must be considered artefactual.}

\item{delta}{Integer. The maximum numbers of consecutive CCF windows below threshold to be allowed in an artefactual streak without determining its end. A value of 1 is
default and recommended, but it can be increased if the reports become too long (e.g. with very noisy source material, or when working with very small ccf windows),  to achieve
the desired level of reporting detail.}

\item{duration}{Integer. Minimum duration of the artefacts to be reported. Note that artefacts smaller than the CCF windows increments cannot be detected.}
}
\value{
a data.frame object with all potential artefact epochs
}
\description{
High synchronization values for extended time durations may be the effect of artefacts in the MEA data. For instance subject 2 movement may have
been captured by subject 1's camera (or ROI) as well, or some environment characteristic (e.g. light) is changing for both cameras (or ROIs). This function identifies
those moments allowing to inspect the original videos with temporal precision.
**Please note that is impossible to discriminate real high synchronization phenomena from artefacts without inspecting the
original videos.**
}
\details{
The function only considers lag_zero correlations as MEA artefacts are expected to be non-lagged phenomena.
}
\examples{
## read the first 4 minutes of the normal sample
## (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                      s1Name = "Patient", s2Name = "Therapist",
                      idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_normal <- MEAccf(mea_normal, lagSec = 5, winSec = 30, incSec = 10, ABS = FALSE)

## find potential artefacts with various granularity of reporting
print(CCFartefacts(mea_normal, threshold = 0.2, delta=1))
print(CCFartefacts(mea_normal, threshold = 0.2, delta=5))
print(CCFartefacts(mea_normal, threshold = 0.2, delta=5, duration=60))

}
