% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_pve.R
\name{calc_pve}
\alias{calc_pve}
\title{Calculating phenotypic variation explained by neighbor effects}
\usage{
calc_pve(
  genoprobs,
  pheno,
  smap,
  s_seq,
  addcovar = NULL,
  grouping = rep(1, nrow(smap)),
  response = c("quantitative", "binary"),
  fig = TRUE,
  contrasts = NULL
)
}
\arguments{
\item{genoprobs}{Conditional genotype probabilities as taken from \code{qtl::calc.genoprob()}.}

\item{pheno}{A vector of individual phenotypes.}

\item{smap}{A matrix showing a spatial map for individuals. The first and second column include spatial positions along an x-axis and y-axis, respectively.}

\item{s_seq}{A numeric vector including a set of the maximum spatial distance between a focal individual and neighbors to define neighbor effects. A scalar is also allowed.}

\item{addcovar}{An optional matrix including additional non-genetic covariates. It contains no. of individuals x no. of covariates.}

\item{grouping}{An optional integer vector assigning each individual to a group. This argument can be used when \code{smap} contains different experimental replicates. Default setting means that all individuals are belong to a single group.}

\item{response}{An optional argument to select trait types. The \code{"quantitative"} or \code{"binary"} applies the \code{"lmm.aireml()"} or \code{"logistic.mm.aireml()"} for a mixed model, respectively.}

\item{fig}{TRUE/FALSE to add a figure of Delta PVE or not.}

\item{contrasts}{An optional vector composed of three TRUE/FALSE values, which represents the presence/absence of specific genotypes as c(TRUE/FALSE, TRUE/FALSE, TRUE/FALSE) = AA, AB, BB. If \code{NULL}, it is compiled from \code{genoprobs} automatically.}
}
\value{
A matrix containing the maximum neighbor distance, phenotypic variation explained by neighbor effects, and p-value by a likelihood ratio test.
\itemize{
\item{\code{scale}} {Maximum neighbor distance given as an argument}
\item{\code{Var_nei}} {Proportion or ratio of phenotypic variation explained (PVE or RVE) by neighbor effects for linear or logistic mixed models, respectively}
\item{\code{p-value}} {p-value by a likelihood ratio test between models with or without neighbor effects}
}
}
\description{
A function to calculate the proportion or ratio of phenotypic variation explained (PVE or RVE) by neighbor effects for a series of neighbor distance (\code{s_seq}) using mixed models.
}
\details{
This function calls linear or logistic mixed models via the \code{gaston} package (Perdry & Dandine-Roulland 2020).
If \code{"binary"} is selected, \code{Var_nei} in the output is given by the proportion of phenotypic variation explained (PVE) by neighbor effects as PVEnei =\eqn{\sigma^2_2/(\sigma^2_1+\sigma^2_2+\sigma^2_e)}.
If \code{"binary"} is selected, \code{Var_nei} is given by the ratio of phenotypic variation explained (RVE) by neighbor effects as RVEnei =\eqn{\sigma^2_2/\sigma^2_1} and p-values are not available.
This is because a logistic mixed model \code{logistic.mm.aireml()} called via the \code{gaston} package does not provide \eqn{\sigma^2_e} and log-likelihood (see Chen et al. 2016 for the theory).
}
\examples{
set.seed(1234)
test_map <- qtl::sim.map(len=rep(20,5),n.mar=3,include.x=FALSE)
test_cross <- qtl::sim.cross(test_map,n.ind=50)
test_smap <- cbind(runif(50,1,100),runif(50,1,100))
test_genoprobs <- qtl::calc.genoprob(test_cross,step=2)
s_seq <- quantile(dist(test_smap),c(0.1*(1:10)))

test_pve <- calc_pve(genoprobs=test_genoprobs,
                     pheno=test_cross$pheno$phenotype,
                     smap=test_smap, s_seq=s_seq,
                     )
}
\references{
\itemize{
\item Perdry H, Dandine-Roulland C (2019) gaston: Genetic Data Handling (QC, GRM, LD, PCA) & Linear Mixed Models. R package version 1.5.5. https://CRAN.R-project.org/package=gaston
\item Chen H, Wang C, Conomos M. et al. (2016) Control for population structure and relatedness for binary traits in genetic association studies via logistic mixed models. The American Journal of Human Genetics 98: 653-666.
}
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
