% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{plot.rspde.result}
\alias{plot.rspde.result}
\title{Posterior plots for field parameters for an \code{inla_rspde} model
from a \code{rspde.result} object}
\usage{
\method{plot}{rspde.result}(
  x,
  which = c("tau", "kappa", "nu"),
  caption = list("Posterior density for tau", "Posterior density for kappa",
    "Posterior density for nu"),
  sub.caption = NULL,
  type_plot = "l",
  ask = prod(graphics::par("mfcol")) < length(which) && grDevices::dev.interactive(),
  main = "",
  cex.oma.main = 1.25,
  cex.caption = 1,
  ylab = "Density",
  xlab = "x",
  ...
)
}
\arguments{
\item{x}{A \code{rspde.result} object.}

\item{which}{For which parameters the posterior should be plotted?}

\item{caption}{captions to appear above the plots; character
vector or list of
valid graphics annotations. Can be set to "" or NA to suppress all captions.}

\item{sub.caption}{common title-above the figures if there are more than one.}

\item{type_plot}{what type of plot should be drawn. The default is 'l'.}

\item{ask}{logical; if \code{TRUE}, the user is asked before each plot.}

\item{main}{character; title to be placed at each plot additionally
(and above) all captions.}

\item{cex.oma.main}{controls the size of the sub.caption only if
that is above the figures when there is more than one.}

\item{cex.caption}{controls the size of caption.}

\item{ylab}{Label for y axis.}

\item{xlab}{Label for x axis.}

\item{...}{Additional arguments.}
}
\value{
Called for its side effects.
}
\description{
Posterior plots for rSPDE field parameters in their
original scales.
}
\examples{
\donttest{ #tryCatch version
tryCatch({
if (requireNamespace("INLA", quietly = TRUE)){
library(INLA)

set.seed(123)

m <- 100
loc_2d_mesh <- matrix(runif(m * 2), m, 2)
mesh_2d <- inla.mesh.2d(
  loc = loc_2d_mesh,
  cutoff = 0.05,
  max.edge = c(0.1, 0.5)
)
sigma <- 0.01
range <- 0.2
nu <- 0.8
kappa <- sqrt(8 * nu) / range
op <- matern.operators(
  mesh = mesh_2d, nu = nu,
  kappa = kappa, sigma = sigma, m = 2
)
u <- simulate(op)
A <- inla.spde.make.A(
  mesh = mesh_2d,
  loc = loc_2d_mesh
)
sigma.e <- 0.1
y <- A \%*\% u + rnorm(m) * sigma.e
Abar <- rspde.make.A(mesh = mesh_2d, loc = loc_2d_mesh)
mesh.index <- rspde.make.index(name = "field", mesh = mesh_2d)
st.dat <- inla.stack(
  data = list(y = as.vector(y)),
  A = Abar,
  effects = mesh.index
)
rspde_model <- rspde.matern(
  mesh = mesh_2d,
  nu_upper_bound = 2
)
f <- y ~ -1 + f(field, model = rspde_model)
rspde_fit <- inla(f,
  data = inla.stack.data(st.dat),
  family = "gaussian",
  control.predictor =
    list(A = inla.stack.A(st.dat)),
           inla.mode = "experimental"
)
result <- rspde.result(rspde_fit, "field", rspde_model)
plot(result)
}
#stable.tryCatch
}, error = function(e){print("Could not run the example")})
}
}
