% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{samples_db}
\alias{samples_db}
\title{Example IGH human naive b-cell repertiore}
\format{
A \code{data.frame} in Change-O format (\url{https://changeo.readthedocs.io/en/version-0.4.1---airr-standards/standard.html}) containing the following columns:
\itemize{
  \item \code{'SUBJECT'}: subject names
  \item \code{'V_CALL'}: V allele call(s) (in an IMGT format)
  \item \code{'D_CALL'}: D allele call(s) (in an IMGT format, only for heavy chains)
  \item \code{'J_CALL'}: J allele call(s) (in an IMGT format)
}
}
\usage{
samples_db
}
\description{
A \code{data.frame} of example IGH human naive b-cell repertiore data from five
individuals (see references). Overall, the data set includes 6 samples.
A single individual has two samples (Individual I5),
one is short read sequences from  BIOMED-2 protocol primers for framework 2 region (The sample is annotated I5_FR2).
}
\references{
Gidoni, Moriah, \emph{et al}. Mosaic deletion patterns of the human antibody heavy chain
gene locus shown by Bayesian haplotyping.
\emph{Nature Communications}. 10.1 (2019): 628.
}
\keyword{AIRR}
\keyword{NGS}
\keyword{antibody}
\keyword{data}
