% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/howrobust.R
\name{how_robust}
\alias{how_robust}
\title{Quick method to see how robust a list of ID codes is to erasures}
\usage{
how_robust(codes)
}
\arguments{
\item{codes}{a list of numeric ID sequences generated by \code{\link{rs_IDs}}, \code{\link{brute_IDs}}, or \code{\link{tweaked_IDs}}. This can be either in matrix or list form.}
}
\value{
a named, flattened list that contains a contingency table with the frequency of crosswise Hamming distances
}
\description{
Given a list (or matrix) of generated numeric ID codes, this function does a crosswise comparison. It compares the 'Hamming distance' between every pair of given ID sequences, then returns a contingency table with the frequency of Hamming distances found. These Hamming distances represent how robust the coding scheme is to erasure errors. If a particular robustness to erasure is desired, there should be no distances equal to or lower than that robustness.
}
\examples{
 #Let's generate some unique IDs given:
total.length <- 4  #we have four positions to mark,
redundancy <- 2    #we're interested in being robust to two erasures,
alphabet <- 5      #and we currently have five types of color bands in stock

codes <- rs_IDs(total.length, redundancy, alphabet)
 #Given that we specified a robustness of 2,
 #there should be no counts of "dist.2" or lower
how_robust(codes)


}
\references{
For information on \href{https://en.wikipedia.org/wiki/Hamming_distance}{Hamming distances}.

 For information on \href{https://en.wikipedia.org/wiki/Erasure_code}{erasure coding}.
}
\seealso{
\code{\link{how_many}}.
}
\author{
Andrew Burchill, \email{andrew.burchill@asu.edu}
}
