% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GLSZM.R
\name{glszm}
\alias{glszm}
\title{Gray level size zone matrix.}
\usage{
glszm(data, n_grey = 32, truncate = TRUE, ...)
}
\arguments{
\item{data}{A numeric 2D matrix.}

\item{n_grey}{an integer value, the number of grey levels the image should
be quantized into.}

\item{truncate}{Logical. Remove values for sizes that have no entries}

\item{...}{Can be given verbose=FALSE to suppress output from the n_grey conversion.}
}
\value{
a matrix of dimension n_grey by region size, the GLSZM. The column
  names represent the region size, row names represent grey level, and
  the entries represent the count of how many times a given size of given grey level
  occur.
}
\description{
\code{glszm} returns a gray level size zone matrix for a given matrix.
}
\details{
Can be visualized using \code{image(glszm(data))}. For visualization info
see \code{?image.radiomics}
}
\examples{
\dontrun{
image(psf)
glszm(psf)

image(discretizeImage(psf, n_grey=5, verbose=F))
glszm(psf, n_grey=5, verbose=F)
}
}
\references{
\url{http://thibault.biz/Research/ThibaultMatrices/GLSZM/GLSZM.html}
}

