% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{rainette2_plot}
\alias{rainette2_plot}
\title{Generate a clustering description plot from a rainette2 result}
\usage{
rainette2_plot(
  res,
  dtm,
  k = NULL,
  criterion = c("chi2", "n"),
  complete_groups = FALSE,
  type = c("bar", "cloud"),
  n_terms = 15,
  free_scales = FALSE,
  measure = c("chi2", "lr"),
  show_negative = TRUE,
  text_size = 10
)
}
\arguments{
\item{res}{result object of a \code{rainette2} clustering}

\item{dtm}{the dfm object used to compute the clustering}

\item{k}{number of groups. If NULL, use the biggest number possible}

\item{criterion}{criterion to use to choose the best partition. \code{chi2} means
the partition with the maximum sum of chi2, \code{n} the partition with the
maximum size.}

\item{complete_groups}{if TRUE, documents with NA cluster are reaffected by
k-means clustering initialised with current groups centers.}

\item{type}{type of term plots : barplot or wordcloud}

\item{n_terms}{number of terms to display in keyness plots}

\item{free_scales}{if TRUE, all the keyness plots will have the same scale}

\item{measure}{statistics to compute}

\item{show_negative}{if TRUE, show negative keyness features}

\item{text_size}{font size for barplots, max word size for wordclouds}
}
\value{
A gtable object.
}
\description{
Generate a clustering description plot from a rainette2 result
}
\seealso{
\code{\link[quanteda:textstat_keyness]{quanteda::textstat_keyness()}}, \code{\link[=rainette2_explor]{rainette2_explor()}}, \code{\link[=rainette2_complete_groups]{rainette2_complete_groups()}}
}
