% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpPar.R
\name{mpPar}
\alias{mpPar}
\title{Representing Maximal Procedure}
\usage{
mpPar(N, mti, ratio = c(1, 1), groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{mti}{maximum tolerated imbalance in patient numbers during the trial.}

\item{ratio}{vector of length \code{K}. The total sample number \code{N} and
all used block lengths (\code{bc}) have to be divisible by \code{sum(ratio)}.}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{mpPar}.
}
\description{
Represents the Maximal Procedure.
}
\details{
Fix the total sample size \code{N} and the \code{mti}. Afterwards, the patients
are assigned to each treatment arm according to the \code{ratio}.
All randomization sequences are equiprobable.
}
\references{
V.W. Berger, A. Ivanova and M.D. Knoll (2003) Minimizing predictability while
retaining balance through the use of less restrictive randomization
procedures. \emph{Statistics in Medicine}, \strong{19}, 3017-28.
}
\seealso{
Other randomization procedures: 
\code{\link{abcdPar}},
\code{\link{bbcdPar}},
\code{\link{bsdPar}},
\code{\link{chenPar}},
\code{\link{crPar}},
\code{\link{createParam}()},
\code{\link{ebcPar}},
\code{\link{gbcdPar}},
\code{\link{hadaPar}},
\code{\link{pbrPar}},
\code{\link{rarPar}},
\code{\link{rpbrPar}},
\code{\link{rtbdPar}},
\code{\link{tbdPar}},
\code{\link{udPar}}
}
\concept{randomization procedures}
