% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geobuffer_points.R
\name{geobuffer_points}
\alias{geobuffer_points}
\title{Geodesic buffer for unprojected points}
\usage{
geobuffer_points(data, radius, by_point = FALSE, n_segments = 100,
                 wrap_antimeridian = FALSE)
}
\arguments{
\item{data}{matrix of geographic unprojected coordinates (i.e., in EPSG:4326).
Columns must be "longitude" and "latitude", in that order.}

\item{radius}{(numeric) radius of buffer in meters.}

\item{by_point}{(logical) whether or not to do buffers by point. If FALSE, the
default, buffer polygons that overlap will be dissolved to obtain an only
feature. Default = 100.}

\item{n_segments}{(numeric) number of segments to approximate a circle.}

\item{wrap_antimeridian}{(logical) whether or not to wrap buffers in the
antimeridian when they overpass it.}
}
\value{
A SpatialPolygons object of buffered points. Final projection is WGS84
(EPSG:4326).
}
\description{
geobuffer_points helps in creating geodesic buffers of points
represented by longitude and latitude coordinates.
}
\details{
The process is done using an algorithm that calculates the buffer in the North
Pole and then rotates this buffer into the actual location. The rotation is
effected by converting the original buffer to geocentric Cartesian (XYZ)
coordinates. A matrix multiplication helps to  rotate those coordinates
along the Prime Meridian to the target latitude, converting the coordinates
back to Geographic (WGS84). Then the buffer is spun around the Earth's
axis by adding the target longitude to each second coordinate.

The algorithm was developed by a moderator of the Geographic Information
Systems Stack Exchange (online community). More details are available available
at the following
\href{https://gis.stackexchange.com/questions/250389/euclidean-and-geodesic-buffering-in-r}{site}.
}
\examples{
#data
data("occ_p", package = "rangemap")
coords <- occ_p[, 2:3]

# buffers
bufferp <- geobuffer_points(data = coords, radius = 25000)

sp::plot(bufferp, axes = TRUE)
}
