% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_beads.R
\name{PlotBeads}
\alias{PlotBeads}
\title{Illustrate beading plot}
\usage{
PlotBeads(data, color = NULL)
}
\arguments{
\item{data}{DATA of metrics for treatment ranking.}

\item{color}{LIST of colors for treatments in a network meta-analysis.}
}
\value{
\strong{PlotBeads()} returns a beading plot.
}
\description{
\strong{PlotBeads()} is a function for illustrating beading plot.
}
\examples{
## Not run:
library(netmeta)
data(Senn2013)
nma <- netmeta(TE, seTE, treat1, treat2,
  studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
nma.1 <- GetMetrics(nma, outcome = "HbA1c.random", prefer = "small", metrics = "SUCRA",
  model = "random", simt = 1000)
nma.2 <- GetMetrics(nma, outcome = "HbA1c.common", prefer = "small", metrics = "SUCRA",
  model = "common", simt = 1000)

# Combine metrics of multiple outcomes
dataMetrics <- rbind(nma.1, nma.2)

# Set data for rankinma
dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
  metrics = SUCRA, metrics.name = "SUCRA")

# Illustrate beading plot
PlotBeads(data = dataRankinma)
## End(Not run)

}
\seealso{
\code{\link{GetMetrics}} \code{\link{SetMetrics}}
}
\author{
Chiehfeng Chen & Enoch Kang
}
