% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Greedy.R
\name{Greedy}
\alias{Greedy}
\title{Estimate the MLE of a Mallows-Binomial distribution using the Greedy method}
\usage{
Greedy(Pi, X, M, localsearch = 0)
}
\arguments{
\item{Pi}{Matrix of partial or complete rankings, one row per ranking.}

\item{X}{Matrix of ratings, one row per judge and one column per object.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}

\item{localsearch}{Numberic specifying the maximum Kendall distance to the first-estimated consensus ranking of rankings which should be considered during a post-hoc local search; defaults to 0 (indicating no local search).}
}
\value{
List with elements pi0 (estimated consensus ranking MLE),  p (estimated object quality parameter MLE), theta (estimated scale parameter MLE), and numnodes (number of nodes traversed during algorithm, a measure of computational complexity).
}
\description{
This function estimates the MLE of a Mallows-Binomial distribution using the Greedy method, as described in Pearce and Erosheva (2022).
}
\examples{
Pi <- matrix(c(1,2,3,4,2,1,NA,NA),byrow=TRUE,nrow=2)
X <- matrix(c(0,1,2,3,1,2,2,5),byrow=TRUE,nrow=2)
Greedy(Pi=Pi,X=X,M=5)
Greedy(Pi=Pi,X=X,M=5,localsearch=2)
 
}
