% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi.R
\name{psi}
\alias{psi}
\title{Psi function}
\usage{
psi(theta, J, R, log = FALSE)
}
\arguments{
\item{theta}{Non-negative scale parameter.}

\item{J}{Positive integer indicating total number of objects.}

\item{R}{Positive integer <=\code{J} indicating size of partial ranking.}

\item{log}{Boolean indicating if log(Psi) should be returned.}
}
\value{
Numeric representing normalizing constant of a Mallows distribution.
}
\description{
This function calculates the normalizing constant of a Mallows distribution under the Kendall distance.
}
\examples{
psi(theta=1,J=10,R=8)
psi(theta=2,J=3,R=3,log=TRUE)
 
}
