% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.fit.R
\name{tree.matrix}
\alias{tree.matrix}
\title{Generate matrix A encoding ancestor-descendant relationships
in an hclust tree}
\usage{
tree.matrix(hc)
}
\arguments{
\item{hc}{An \code{hclust} object.}
}
\value{
Returns a \code{nvars}-by-\code{nnodes} binary matrix \code{A}
where \code{nvars} is the number of leaves (we associate covariate with leaf),
and \code{nnodes} is the number of tree nodes (including both leaves and interior nodes).
For an \code{hclust} tree, \code{nnodes} = \code{2*nvars-1}. \code{A[i,j]} is 1 if the \code{i}th leaf
is a descendant of the \code{j}th node in the tree, and 0 otherwise. \emph{By default, we
let the first \code{nvars} columns correspond to leaves and the remaining
\code{nvars-1} columns correspond to interior nodes.}
\code{A} is in sparse matrix format (inherit from class
\code{\link[Matrix]{sparseMatrix}} as in package \code{Matrix}).
}
\description{
The function generates the binary matrix \code{A} defined in Yan
and Bien (2018). The matrix encodes ancestor-descendant relationships between leaves
and tree nodes in an \code{hclust} tree.
}
\examples{
# For a perfect binary tree of depth 2 below
#
#      3
#      /\\
#    1    2
#   /\\    /\\
# -1 -2 -3 -4
#
# A can expressed as the following:
A_true <- cbind(diag(4),
                as.matrix(c(1, 1, 0, 0)),
                as.matrix(c(0, 0, 1, 1)),
                as.matrix(c(1, 1, 1, 1)))
# Now use tree.matrix to generate A
tree0 <- list()
tree0$merge <- matrix(c(-1, -2, -3, -4, 1, 2),
                      ncol = 2, byrow = TRUE)
tree0$labels <- c("leaf1", "leaf2", "leaf3", "leaf4")
A <- tree.matrix(tree0)
all(A_true == as.matrix(A))

# Another example
hc <- hclust(dist(USArrests), "ave")
A <- tree.matrix(hc)

}
\references{
Yan, X. and Bien, J. (2018) \emph{Rare Feature Selection in High Dimensions}, \url{https://arxiv.org/abs/1803.06675}.
}
\seealso{
\code{\link{find.leaves}} for finding descendant leaves of a node.
}
