% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmm.sim.R
\name{hsmm.sim}
\alias{hsmm.sim}
\title{Simulate a Gaussian hidden semi-Markov series with / without autoregressive
structures}
\usage{
hsmm.sim(ns, mod)
}
\arguments{
\item{ns}{length of the simulated series}

\item{mod}{list consisting of at least the following items: 
mod$m = number of states, 
mod$delta = vector of prior probabilities, 
mod$gamma = matrix of state transition probabilies.
mod$mu = list of means, 
mod$sigma = list of covariance matrices.
mod$d = list of state duration probabilities.
For autoregressive hidden markov models, we also need the additional items:
mod$auto = list of autocorrelation matrices. 
mod$arp = order of autoregressive.}
}
\value{
a list containing simulated series and states
}
\description{
Simulate a Gaussian hidden semi-Markov series with / without autoregressive
structures
}
\examples{
set.seed(351)
#Gaussian HSMM 3 hidden states (no autoregressive structure)
m <- 3
mu <- list(c(3),c(-2),c(0))
sigma <- list(as.matrix(1), as.matrix(0.8),as.matrix(0.3))
delta <- c(0.3,0.3,0.4)
gamma <- matrix(c(0,0.5,0.5,0.5,0,0.5,0.5,0.5,0),3,3,byrow=TRUE)
d <- list(c(0.4,0.3,0.2,0.1), c(0.5,0.25,0.25), c(0.7,0.3))
mod1 <- list(m=m,mu=mu,sigma=sigma,delta=delta,gamma=gamma,d=d)
sim1 <- hsmm.sim(500,mod1)
y1 <- sim1$series
fit1 <- em.semi(y=y1, mod=mod1)

\dontrun{
#AR(2) Gaussian HSMM with 3 hidden states
m <- 2
mu <- list(c(3,4,5),c(-2,-3,-4))
sigma <- list(diag(1.3,3), 
            matrix(c(1,-0.3,0.2,-0.3,1.5,0.3,0.2,0.3,2),3,3,byrow=TRUE))
delta <- c(0.5,0.5)
gamma <- matrix(c(0,1,1,0),2,2,byrow=TRUE)
d <- list(c(0.4,0.2,0.1,0.1,0.1,0.1),c(0.5,0.3,0.2))
auto <- list(matrix(c(0.3,0.2,0.1,0.4,0.3,0.2,
                     -0.3,-0.2,-0.1,0.3,0.2,0.1,
                      0,0,0,0,0,0),3,6,byrow=TRUE),
            matrix(c(0.2,0,0,0.4,0,0,
                      0,0.2,0,0,0.4,0,
                     0,0,0.2,0,0,0.4),3,6,byrow=TRUE))
mod2 <- list(m=m,mu=mu,sigma=sigma,delta=delta,gamma=gamma,
            auto=auto,arp=2,d=d)
sim2 <- hsmm.sim(2000,mod2)
y2 <- sim2$series
fit2 <- em.semi(y=y2, mod=mod2, arp=2)
}
}
\references{
Rabiner, Lawrence R. "A tutorial on hidden Markov models and 
selected applications in speech recognition." Proceedings of the 
IEEE 77.2 (1989): 257-286.
}
