% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zonalDT.R
\name{zonalDT}
\alias{zonalDT}
\title{Speedy Zonal Statistics}
\usage{
zonalDT(x, z, fun = sum, na.rm = TRUE)
}
\arguments{
\item{x}{A \code{Raster*} to the totality of whose values
\code{fun} should be applied within each zone.}

\item{z}{A categorical \code{RasterLayer} with codes representing
zones.}

\item{fun}{A name or character string giving the function to be
applied to summarize the values by zone. It needs to return a
single (or at least a length-one vector). If \code{x} might
contain any \code{NA} values, it should be equipped to handle
them. For large rasters, this function needs to be one, like
\code{sum()} whose value is the same even if carried out in a
two-stage application (i.e. first to data subsets and then to
the results of those subset applications).}

\item{na.rm}{Logical. If \code{TRUE}, \code{NA} values in \code{x}
are ignored.}
}
\value{
A \code{data.table} with a summary value for each zone.
}
\description{
A fast \code{data.table}-based alternative to
\code{\link[raster:zonal]{raster::zonal()}}.
}
\examples{
r <- raster(ncols = 10, nrows = 10)
r[] <- runif(ncell(r)) * 1:ncell(r)
z <- r
z[] <- rep(1:5, each = 20)
## for big files, use a character value rather than a function
zonalDT(r, z, "sum")

## for smaller files you can also provide a function
zonalDT(r, z, mean)
zonalDT(r, z, min)

## multiple layers
zonalDT(stack(r, r*10), z, "sum")
}
\author{
Joshua O'Brien
}
