% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{rotate_lines}
\alias{rotate_lines}
\title{Rotate Lines}
\usage{
rotate_lines(
  lines,
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3)
)
}
\arguments{
\item{lines}{The existing line scene.}

\item{angle}{Default \code{c(0,0,0)}. The rotation amount for the x/y/z axes, in degrees.}

\item{pivot_point}{Default \code{c(0,0,0)}. The pivot point of the rotation.}

\item{order_rotation}{Default \code{c(1,2,3)}. The order in which to perform the rotations.#'}
}
\value{
Rotated lines.
}
\description{
Rotate Lines
}
\examples{
if(run_documentation()) {
#Generate a cube out of lines
cube_outline = generate_line(start = c(-1, -1, -1), end = c(-1, -1, 1)) |>
  add_lines(generate_line(start = c(-1, -1, -1), end = c(-1, 1, -1))) |>
  add_lines(generate_line(start = c(-1, -1, -1), end = c(1, -1, -1))) |>
  add_lines(generate_line(start = c(-1, -1, 1), end = c(-1, 1, 1))) |>
  add_lines(generate_line(start = c(-1, -1, 1), end = c(1, -1, 1))) |>
  add_lines(generate_line(start = c(-1, 1, 1), end = c(-1, 1, -1))) |>
  add_lines(generate_line(start = c(-1, 1, 1), end = c(1, 1, 1))) |>
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, -1, -1))) |>
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, 1, 1))) |>
  add_lines(generate_line(start = c(1, -1, -1), end = c(1, -1, 1))) |>
  add_lines(generate_line(start = c(1, -1, 1), end = c(1, 1, 1))) |>
  add_lines(generate_line(start = c(-1, 1, -1), end = c(1, 1, -1)))
rasterize_lines(cube_outline,lookfrom=c(0,6,10))
}
if(run_documentation()) {
#Rotate the cube 30 degrees around the y-axis
rotated_cube = color_lines(rotate_lines(cube_outline,angle=c(0,30,0)),color="red")
rasterize_lines(add_lines(cube_outline,rotated_cube),lookfrom=c(0,6,10))
}
if(run_documentation()) {
#Rotate the cube 30 degrees around each axis, in this order: x,y,z
rotated_cube = color_lines(rotate_lines(cube_outline,angle=c(30,30,30)),color="red")
rasterize_lines(add_lines(cube_outline,rotated_cube),lookfrom=c(0,6,10))
}
if(run_documentation()) {
#Rotate the cube 30 degrees around each axis, in this order: z,y,x
rotated_cube = color_lines(rotate_lines(cube_outline,angle=c(30,30,30), 
                           order_rotation = c(3,2,1)),color="red")
rasterize_lines(add_lines(cube_outline,rotated_cube),lookfrom=c(0,6,10))
}
}
