% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shape.R
\name{material_list}
\alias{material_list}
\title{Material List}
\usage{
material_list(
  diffuse = c(0.8, 0.8, 0.8),
  ambient = c(0, 0, 0),
  specular = c(1, 1, 1),
  transmittance = c(1, 1, 1),
  emission = c(0, 0, 0),
  shininess = 10,
  ior = 1,
  dissolve = 1,
  illum = 1,
  texture_location = "",
  normal_texture_location = "",
  specular_texture_location = "",
  ambient_texture_location = "",
  emissive_texture_location = "",
  diffuse_intensity = 1,
  specular_intensity = 1,
  emission_intensity = 1,
  ambient_intensity = 1,
  culling = "back",
  type = "diffuse",
  translucent = TRUE,
  toon_levels = 5,
  toon_outline_width = 0.05,
  toon_outline_color = "black",
  reflection_intensity = 0,
  reflection_sharpness = 0
)
}
\arguments{
\item{diffuse}{Default `c(0.5,0.5,0.5)`. The diffuse color.}

\item{ambient}{Default `c(0,0,0)`. The ambient color.}

\item{specular}{Default `c(1,1,1)`. The specular color.}

\item{transmittance}{Default `c(1,1,1)`. The transmittance}

\item{emission}{Default `c(0,0,0)`. The emissive color.}

\item{shininess}{Default `10.0`. The shininess exponent.}

\item{ior}{Default `1.0`. The index of refraction. If this is not equal to `1.0`, the material will be refractive.}

\item{dissolve}{Default `1.0`. The transparency.}

\item{illum}{Default `1.0`. The illumination.}

\item{texture_location}{Default `""`. The diffuse texture location.}

\item{normal_texture_location}{Default `""`. The normal texture location.}

\item{specular_texture_location}{Default `""`. The specular texture location.}

\item{ambient_texture_location}{Default `""`. The ambient texture location.}

\item{emissive_texture_location}{Default `""`. The emissive texture location.}

\item{diffuse_intensity}{Default `1`. The diffuse intensity.}

\item{specular_intensity}{Default `1`. The specular intensity.}

\item{emission_intensity}{Default `1`. The emission intensity.}

\item{ambient_intensity}{Default `1`. The ambient intensity.}

\item{culling}{Default `"back"`. The culling type. Options are `back`, `front`, and `none`.}

\item{type}{Default `"diffuse"`. The shader type. Options include `diffuse`,`phong`,`vertex`, and `color`.}

\item{translucent}{Default `FALSE`. Whether light should transmit through a semi-transparent material.}

\item{toon_levels}{Default `5`. Number of color breaks in the toon shader.}

\item{toon_outline_width}{Default `0.05`. Expansion term for model to specify toon outline width.}

\item{toon_outline_color}{Default `black`. Toon outline color.}

\item{reflection_intensity}{Default `0.0`. Intensity of the reflection of the environment map, if present. This will be ignored if the material is refractive.}

\item{reflection_sharpness}{Default `1.0`. Sharpness of the reflection, where lower values have blurrier reflections. Must be greater than zero and less than one.}
}
\value{
List of material properties.
}
\description{
Generate a material properties list.
}
\examples{
if(rayvertex:::run_documentation()) {
mat_prop = material_list(diffuse="purple", type="phong", shininess=20,
                        ambient="purple", ambient_intensity=0.3,
                        specular = "red", specular_intensity=2)
                        
p_sphere = sphere_mesh(position=c(555/2,555/2,555/2), 
                      radius=40,material=mat_prop)
                      
rasterize_scene(p_sphere, light_info=directional_light(direction=c(0.1,0.6,-1)))
}
}
