% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{accrate.depth.ghost}
\alias{accrate.depth.ghost}
\title{Plot modelled accumulation rates against the depths of a core.}
\usage{
accrate.depth.ghost(
  set = get("info"),
  d = set$elbows,
  d.lim = c(),
  acc.lim = c(),
  d.lab = c(),
  cmyr = FALSE,
  acc.lab = c(),
  dark = 1,
  rgb.scale = c(0, 0, 0),
  rgb.res = 100,
  prob = 0.95,
  plot.range = TRUE,
  range.col = grey(0.5),
  range.lty = 2,
  plot.mean = TRUE,
  mean.col = "red",
  mean.lty = 2,
  plot.median = TRUE,
  median.col = "blue",
  median.lty = 2,
  rotate.axes = FALSE,
  rev.d = FALSE,
  rev.acc = FALSE,
  bty = "l"
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{d}{The depths for which the accumulation rates are to be calculated. Default to the entire core.}

\item{d.lim}{Axis limits for the depths.}

\item{acc.lim}{Axis limits for the accumulation rates.}

\item{d.lab}{Label for the depth axis.}

\item{cmyr}{Accumulation rates can be calculated in cm/year or year/cm. By default \code{cmyr=FALSE} and accumulation rates are calculated in year per cm. Axis limits are difficult to calculate when \code{cmyr=TRUE}, so a manual adaptation of \code{acc.lim} might be a good idea.}

\item{acc.lab}{Axis label for the accumulation rate.}

\item{dark}{The darkest grey value is dark=1 by default; lower values will result in lighter grey but values >1 are not advised.}

\item{rgb.scale}{The function to produce a coloured representation of all age-models. Needs 3 values for the intensity of red, green and blue. Defaults to grey-scales: \code{rgb.scale=c(0,0,0)}, but could also be, say, scales of red (\code{rgb.scale=c(1,0,0)}).}

\item{rgb.res}{Resolution of the colour spectrum depicting the age-depth model. Default \code{rgb.res=100}.}

\item{prob}{Probability ranges. Defaults to \code{prob=0.95}.}

\item{plot.range}{If \code{plot.range=TRUE}, the confidence ranges (two-tailed; half of the probability at each side) are plotted.}

\item{range.col}{Colour of the confidence ranges.}

\item{range.lty}{Line type of the confidence ranges.}

\item{plot.mean}{If \code{plot.mean=TRUE}, the means are plotted.}

\item{mean.col}{Colour of the mean accumulation rates.}

\item{mean.lty}{Type of the mean lines.}

\item{plot.median}{If \code{plot.mean=TRUE}, the medians are plotted.}

\item{median.col}{Colour of the median accumulation rates.}

\item{median.lty}{Type of the median lines.}

\item{rotate.axes}{The default is to plot the accumulation rates horizontally and the depth vertically (\code{rotate.axes=FALSE}). Change rotate.axes value to rotate axes.}

\item{rev.d}{The direction of the depth axis can be reversed from the default (\code{rev.d=TRUE}.}

\item{rev.acc}{The direction of the accumulation rate axis can be reversed from the default (\code{rev.acc=TRUE}).}

\item{bty}{Type of box to be drawn around the plot (\code{"n"} for none, and \code{"l"} (default), \code{"7"}, \code{"c"}, \code{"u"}, or \code{"o"} for correspondingly shaped boxes).}
}
\value{
A grey-scale plot of accumulation rate against core depth.
}
\description{
Plot grey-scale representation of modelled accumulation rates over a core's depth. Each section of the core (see Bacon's option \code{"thick"}) will have modelled accumulation rates.
}
\details{
This plot shows the modelled accumulation rates in grey-scales, where darker grey indicates more likely accumulation rates.
Axis limits for accumulation rates are estimated automatically, however upper limits can be very variable (and thus hard to predict)
if calculated in cm/yr; therefore you might want to manually adapt the axis limits after plotting with default settings (e.g., \code{acc.lim=c(0,1)}). See also \code{accrate.age.ghost}, \code{accrate.depth} and \code{accrate.age}.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(yr.res=50, d.res=50, d.by=10)
  layout(1)
  accrate.depth.ghost()
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
