% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_people_name}
\alias{rba_reactome_people_name}
\title{Get Persons Information by Name}
\usage{
rba_reactome_people_name(person_name, exact_match = FALSE, ...)
}
\arguments{
\item{person_name}{first and last name of the person}

\item{exact_match}{Logical: should the supplied name be considered as
an exact match? (default = FALSE)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List where each element is a search hit contains the person's
  information.
}
\description{
Using this function you can query people by partially matching or exact
  name and retrieve a list of matching people in Reactome.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/people/name/{name}"
 \cr "GET https://reactome.org/ContentService/data/people/name/{name}/exact"
}

\examples{
\donttest{
rba_reactome_people_name("Jupe")
}
\donttest{
rba_reactome_people_name("Steve Jupe", exact_match = TRUE)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Person Queries": 
\code{\link{rba_reactome_people_id}()}
}
\concept{"Reactome Content Service - Person Queries"}
