% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_coordinates.R
\name{rba_uniprot_coordinates_location_genome}
\alias{rba_uniprot_coordinates_location_genome}
\title{Get Genome coordinate by Gene Sequence position}
\usage{
rba_uniprot_coordinates_location_genome(
  taxid,
  chromosome,
  g_position = NULL,
  g_start = NULL,
  g_end = NULL,
  ...
)
}
\arguments{
\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.
You can supply up to 20 taxon IDs.}

\item{chromosome}{(Character or Numeric): Chromosome name, e.g. 1, 20, X.}

\item{g_position}{(numeric) Genome location position}

\item{g_start}{(numeric) Genome location position start}

\item{g_end}{(numeric) Genome location position end}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Genome coordinates of your supplied proteins.
}
\description{
Using this function you can retrieve genome coordinates of a given UniProt
  protein by providing Genome location position or range. You can either
  supply 'g_position' alone or supply 'g_start' and 'g_end' together.
}
\details{
For more information about how UniProt imports and calculates genomic
  coordinates data, see:
  \cr McGarvey, P. B., Nightingale, A., Luo, J., Huang, H., Martin, M. J.,
  Wu, C., & UniProt Consortium (2019). UniProt genomic mapping for
  deciphering functional effects of missense variants. Human mutation,
  40(6), 694–705. https://doi.org/10.1002/humu.23738
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/coordinates/glocation
 /\{accession\}:\{pPosition\}"
 \cr "GET https://ebi.ac.uk/proteins/api/coordinates/glocation
 /\{accession\}:\{pStart\}-\{pEnd\}"
}

\examples{
\donttest{
 rba_uniprot_coordinates_location_genome(
 taxid = 9606, chromosome = 11, g_position = 36573305)
}

}
\references{
\itemize{
  \item The UniProt Consortium , UniProt: the Universal Protein
  Knowledgebase in 2025, Nucleic Acids Research, 2024;, gkae1010,
  https://doi.org/10.1093/nar/gkae1010
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Coordinates": 
\code{\link{rba_uniprot_coordinates}()},
\code{\link{rba_uniprot_coordinates_location}()},
\code{\link{rba_uniprot_coordinates_location_protein}()},
\code{\link{rba_uniprot_coordinates_search}()}
}
\concept{"UniProt - Coordinates"}
