% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carto_scale.R
\name{scale_color_carto_c}
\alias{scale_color_carto_c}
\alias{scale_color_carto_d}
\alias{scale_colour_carto_c}
\alias{scale_colour_carto_d}
\alias{scale_fill_carto_c}
\alias{scale_fill_carto_d}
\title{CARTO color scales}
\usage{
scale_color_carto_c(..., type = "quantitative", palette = 1,
  direction = 1, na.value = "#e9e9e9", guide = "colourbar")

scale_color_carto_d(..., type = "qualitative", palette = 1,
  direction = 1, na.value = "#e9e9e9")

scale_colour_carto_c(..., type = "quantitative", palette = 1,
  direction = 1, na.value = "#e9e9e9", guide = "colourbar")

scale_colour_carto_d(..., type = "qualitative", palette = 1,
  direction = 1, na.value = "#e9e9e9")

scale_fill_carto_c(..., type = "quantitative", palette = 1,
  direction = 1, na.value = "#e9e9e9", guide = "colourbar")

scale_fill_carto_d(..., type = "qualitative", palette = 1,
  direction = 1, na.value = "#e9e9e9")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[=discrete_scale]{discrete_scale()}} or
\code{\link[=continuous_scale]{continuous_scale()}} to control name, limits, breaks, labels and so forth}

\item{type}{One of "aggregation", "diverging", "qualitative", or "quantitative"}

\item{palette}{If a string, will use that named palette. If a number, will
index into the list of palettes of appropriate \code{type}}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are as output by \code{\link[=carto_pal]{carto_pal()}}. If -1, the
order of colors is reversed}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more info.}
}
\description{
CARTO color scales
}
\examples{
library(ggplot2)

ggplot(msleep, aes(vore, sleep_total, fill = vore)) +
        geom_boxplot() +
        scale_fill_carto_d(palette = 6, direction = -1)

\dontrun{
library(sf)
library(spData)
library(ggplot2)
ggplot(world, aes(fill = lifeExp)) +
        geom_sf(data = world) +
        coord_sf(crs = "+proj=robin") +
        scale_fill_carto_c(name = "Life expectancy: ",
                           type = "diverging", palette = "Fall", direction = -1) +
        theme_void()

ggplot(world, aes(fill = region_un)) +
        geom_sf(data = world) +
        coord_sf(crs = "+proj=robin")  +
        scale_fill_carto_d(name = "Region: ", palette = "Prism") +
        theme_void()
}
}
