% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rciplot.R
\name{rciplot}
\alias{rciplot}
\title{rciplot}
\usage{
rciplot(
  data,
  pre = NULL,
  post = NULL,
  group = NULL,
  reliability = NULL,
  recovery_cutoff = NULL,
  show_classification_counts = TRUE,
  show_classification_percentages = TRUE,
  higher_is_better = TRUE,
  pre_jitter = 0,
  post_jitter = 0,
  opacity = 0.5,
  size_points = 1,
  size_lines = 0.3,
  draw_meanmid_line = FALSE,
  draw_2sd_functional_line = FALSE,
  draw_2sd_dysfunctional_line = FALSE,
  mean_functional = NULL,
  mean_dysfunctional = NULL,
  sd_functional = 1,
  sd_dysfunctional = 1
)
}
\arguments{
\item{data}{Dataframe containing all relevant data}

\item{pre}{Name of the column in `data` containing pre values}

\item{post}{Name of the column in `data` containing post values}

\item{group}{Name of column by which cases are to be grouped (controls shape
of scatter plot points)}

\item{reliability}{Reliability of the used test / instrument}

\item{recovery_cutoff}{Test score below which individuals are considered
healthy / recovered}

\item{show_classification_counts}{If TRUE, show number of cases for each
classification (e.g. reliable improvement, no reliable change, ...) in legend}

\item{show_classification_percentages}{Expanding on
`show_classification_counts`.If TRUE, show the respective percentage of the
whole sample each classification makes up.}

\item{higher_is_better}{TRUE if higher values indicate a remission / healthy
individual. FALSE if higher values indicate worse health.}

\item{pre_jitter}{Jitter factor to apply to pre values}

\item{post_jitter}{Jitter factor to apply to post values}

\item{opacity}{Alpha value of scatter plot points}

\item{size_points}{Size of scatter plot points.}

\item{size_lines}{Size (thickness) of lines in plot.}

\item{draw_meanmid_line}{Draw a horizontal line indicating the middle between
the population means for a functional (healthy) population and a
dysfunctional (diseased) population, described as criterion *c* in Jacobson &
Truax (1991).}

\item{draw_2sd_functional_line}{Draw a horizontal line indicating a cutoff
at a 2 SD distance from `mean_functional`, described as criterion *b* in
Jacobson & Truax (1991).}

\item{draw_2sd_dysfunctional_line}{Draw a horizontal line indicating a cutoff
at a 2 SD distance from `mean_dysfunctional`, described as criterion *a* in
Jacobson & Truax (1991).}

\item{mean_functional}{Required if `draw_meanmid_line = T` or
`draw_2sd_[dys]functional_line = T`.
Mean test score of the functional population.}

\item{mean_dysfunctional}{Required if `draw_meanmid_line = T` or
`draw_2sd_[dys]functional_line`.
Mean test score of the dysfunctional population.}

\item{sd_functional}{Optional for `draw_meanmid_line = T`. Standard deviation
of the functional population.}

\item{sd_dysfunctional}{Optional for `draw_meanmid_line = T`. Standard
deviation of the dysfunctional population.}
}
\value{
A list containing:\tabular{ll}{
   \code{higher_is_better} \tab
       Exactly the input parameter \code{higher_is_better}
       \cr
   \tab \cr
   \code{reliable_change} \tab
       Pre-Post differences larger than this difference are regarded reliable
       \cr
   \tab \cr
   \code{plot} \tab
       ggplot2 scatter plot analogous to Figure 2 of Jacobson & Truax (1991)
       \cr
}
}
\description{
Create a scatterplot of your sample in which the x-axis maps to
the pre-scores, the y-axis maps to the post-scores and several graphical
elements (lines, colors) allow you to gain a quick overview about reliable
changes in these scores.
An example of this kind of plot is Figure 2 of Jacobson & Truax (1991).
Jacobson-Truax classification (represented in point colors) is always based
on `recovery_cutoff`, not on any other plotted horizontal line (e.g. mid of
means).
}
\examples{
# Using example data from `sample_data.rda` to recreate Figure 2 of
# Jacobson & Truax (1991):
rciplot(
    data = sample_data,
    pre = 'pre_data',
    post = 'post_data',
    reliability = 0.88,
    recovery_cutoff = 104,
    opacity = 1
)

}
