% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseSum.r
\name{groupwiseSum}
\alias{groupwiseSum}
\title{Groupwise sums}
\usage{
groupwiseSum(formula = NULL, data = NULL, var = NULL, group = NULL,
  digits = 3, ...)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variables. e.g. y ~ x1 + x2.}

\item{data}{The data frame to use.}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments passed to the \code{sum} function}
}
\value{
A data frame of statistics by group.
}
\description{
Calculates sums for groups.
}
\details{
The input should include either \code{formula} and \code{data};
             or \code{data}, \code{var}, and \code{group}. (See examples).
}
\note{
The parsing of the formula is simplistic. The first variable on the
         left side is used as the measurement variable.  The variables on the
         right side are used for the grouping variables.
}
\examples{
### Example with formula notation
data(AndersonBias)
groupwiseSum(Count ~ Result + Sex,
             data        = AndersonBias)
                
### Example with variable notation
data(AndersonBias)
groupwiseSum(data        = AndersonBias,
             var         = "Count",
             group       = c("Result", "Sex"))
                      
}
\seealso{
\code{\link{groupwiseMean}}, \code{\link{groupwiseMedian}},
         \code{\link{groupwiseHuber}},
         \code{\link{groupwiseGeometric}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
sum
}
