% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonOneSampleRC.r
\name{wilcoxonOneSampleRC}
\alias{wilcoxonOneSampleRC}
\title{Rank biserial correlation coefficient for one-sample Wilcoxon test}
\usage{
wilcoxonOneSampleRC(
  x,
  mu = NULL,
  zero.method = "Wilcoxon",
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{A vector of observations.}

\item{mu}{The value to compare \code{x} to, as in \code{wilcox.test}}

\item{zero.method}{If \code{"Wilcoxon"},
differences of zero are discarded and then ranks
are determined.
If \code{"Pratt"},
ranks are determined, 
and then differences of zero are discarded.
 If \code{"none"},
differences of zero are not discarded.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{verbose}{If \code{TRUE}, prints information on sample size and ranks.}

\item{...}{Additional arguments passed to the \code{wilcoxsign_test} function.}
}
\value{
A single statistic, rc.  
        Or a small data frame consisting of rc,
        and the lower and upper confidence limits.
}
\description{
Calculates rank biserial correlation coefficient
             effect size
             for one-sample Wilcoxon signed-rank test; confidence intervals
             by bootstrap.
}
\details{
It is recommended that \code{NA}s be removed
          beforehand.
          
          When rc is close to extremes,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
### Example with one zero difference
A = c(11,12,13,14,15,16,17,18,19,20)
#' wilcoxonOneSampleRC(x = A, mu=15)
wilcoxonOneSampleRC(x = A, mu=15, verbose=TRUE, zero.method="Wilcoxon")
wilcoxonOneSampleRC(x = A, mu=15, verbose=TRUE, zero.method="Pratt")
wilcoxonOneSampleRC(x = A, mu=15, verbose=TRUE, zero.method="none")

}
\references{
\url{http://rcompanion.org/handbook/F_02.html}
}
\seealso{
\code{\link{wilcoxonPairedRC}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Matched-pairs rank biserial correlation}
\concept{Wilcoxon signed rank}
\concept{confidence interval}
\concept{effect size}
