
/* 	$Id: swo_coeffs.c 620 2009-01-05 17:25:02Z mritchie $	 */

/* #ifndef lint */
/* static char vcid[] = "$Id: swo_coeffs.c 620 2009-01-05 17:25:02Z mritchie $"; */
/* #endif /\* lint *\/ */


//#include <malloc.h>
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "conifers.h"


#define N_SWO_CONIFERS_COEFFS     19

/* this structure MUST be the EXACT same structure def as the one defined in the header file */
struct CON_SWO_COEFFS_RECORD 
   {
    unsigned long   idx;        /* this is the functional species code -- group in 3.0 */
    unsigned long   type;       /* 0, 1, 2, 3 or 4 */

/* this is required for the user interface */
	 char    group[SP_LENGTH];               /*  name abbreviated from the usfs  */

	 double  d6_growth[MAX_COEFFS];          /* 1  D1: growth coeffs                */
	 double  ht_growth[MAX_COEFFS];          /* 2  D3: growth coeffs                */ 
	 double  cr_growth[MAX_COEFFS];          /* 3  D4: hcb change parameters        */
	 double  crown_ratio[MAX_COEFFS];        /* 4  S3: crown ratio coeffs           */
	 double  crown_width[MAX_COEFFS];        /* 5  S1: crown width coeffs, old CA   */
	 double  max_crown_width[MAX_COEFFS];    /* 6  S2: crown width coeffs, old CA   */
	 double  d6_ht_dbh[MAX_COEFFS];          /* 7  S5, S7                           */
	 double  d6_ht[MAX_COEFFS];              /* 8  S4, S9                           */
	 double  dbh_ht[MAX_COEFFS];             /* 9  S6, S10                          */
	 double  n_stems_from_ht[MAX_COEFFS];    /* 10 S11                              */
	 double  dbh_growth[MAX_COEFFS];         /* 11 D5: dbh growth coefficients      */
	 double  cfvolume4[MAX_COEFFS];          /* 12 S12 volume coefficients          */
	 double  biomass[MAX_COEFFS];            /* 13 S13 biomass coefficients         */
	 double  cw_growth[MAX_COEFFS];          /* 14 D6: cw_growth coefficients       */

} static swo_temp_coeffs[N_SWO_CONIFERS_COEFFS] = {

/*   0         1         2          3         4         5         6        7         8          9         10        11       12       13        14       15        */
{ /* index 0, FBR type = 2 , this is the default for brush */
0, SHRUB, "FBR",
{ 0.052777, 0.046057,      0.0, 0.091103, 0.004174,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
{ 0.376316,-3.461019, 1.677419,-0.099159, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.702099, 0.617866, 1.325870, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.958757, 0.536006, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.528185, 0.891697,-0.067543,-0.121772, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-6.90990,  2.854200, 0.078000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.100000, 0.949400,-0.562100,-1.101110, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3        4         5         6          7          8        9         10         11       12        13       14        15      */
{ /* index 1, FDF type = 0 */
1, CONIFER, "FDF",
{-2.456050,  0.472914, 0.852347,-0.276370,-0.760150,-1.116360,-0.752670,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{-1.320940,  0.031910,      0.0, 0.737997,-0.0022031,0.442926,-0.147460,-0.211590,-0.013090, 0.383800,  -0.2326, -0.18394,      0.0,      0.0,      0.0, 0.000000},
{ 0.170720,  0.080100, 0.259900, 0.319770, 0.085170, 3.465700,-1.787900,-0.696800,-0.644600,-0.644600,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 0.794925,  0.984621,      0.0, 0.485596,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 0.335198,  0.494185, 1.227520,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 4.636600,  1.607800,-0.009625,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 0.778122,  0.666671, 0.174612,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{-1.375748,  1.016819,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 7.127600, -5.364200,-0.261749,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{     0.00,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 0.853812,       0.0,-0.313923,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{ 0.002244,  1.943420, 0.996400, 0.999200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,-2.846200, 1.700900,-3.694100,  2.13820, -3.03960, 2.595100,      0.0,      0.0,      0.0, 0.000000},
{ 0.860817,  0.957470,-0.164190,      0.0,-0.098730,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 2, FHW type = 1 */
2, HARDWOOD, "FHW",
{-1.576230,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0, 0.415000,-0.400000,-0.400000, 0.071864, 0.000000, 0.000000, 0.000000},
{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.698931,       1.0, 0.623570,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.940452,  0.507503, 1.093544,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 4.444300,  1.704000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.757731,  0.674815, 0.219771,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.252449,  0.820175,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 6.394860, -4.522690,-0.235301,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.206178,  0.910631,-0.038421,-0.254271,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.846010,       0.0,-0.923390,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.005887,  1.941650, 0.865620, 1.000000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,-3.278000,-0.019000, 0.000000, 0.000000},
{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15    */
{ /* index 3, FIC type = 0 */
3, CONIFER, "FIC",
{-1.011990,  1.497795, 1.288839,-0.922070,-2.257780,-1.391490,-0.355320,     0.00,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.008570,  0.043976,      0.0, 1.000627,-0.011047, 0.679657,      0.0,-1.438710,-0.296890, 0.276500,-0.400000,-0.400000, 0.090011, 0.000000, 0.000000, 0.000000},
{ 0.166990,  0.063910,      0.0, 0.087540,      0.0, 6.437500,-3.920600,-2.513700,-2.051300,-2.051300,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.955481,  0.880786,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.524076,  0.104512, 1.623529,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.283700,  1.203700,-0.007186,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.749995,  0.666962, 0.177006,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.942158,  0.972699,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 8.903590, -7.536670,-0.163019,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.859116,       0.0,-0.406592,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000 },
{ 0.001930,  2.067700, 0.901700, 0.998480,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,-2.617000, 1.782400,-3.26610,  2.087700, 2.092700, 2.186300, 0.000000, 0.000000, 0.000000, 0.000000},
{ 1.209830,  1.008912,-0.309110,-0.039020,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15   */
{ /* index 4, FPP type = 0 */
4, CONIFER, "FPP",
{-2.205150,  0.244983, 0.890584,-0.181240,-0.569940,-0.287360,-2.038890,     0.00,     0.00,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000},
{-0.607250,  0.025432,      0.0, 0.429110,-0.002203, 0.347872,-0.237750,     0.00,-0.689980,  0.36100,-0.172840,-0.183940, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.351351,  0.105800, 0.725620,      0.0, 0.309350, 2.865400,-1.425800,-3.017700,-1.716000,-1.145200,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000},
{ 0.857195,  0.950446,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.243019,  0.523308, 0.744742,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.483500,  1.343000,-0.008254,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.782144,  0.620201, 0.212225,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.604431,  0.884816,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 8.186460, -6.653220,-0.203531,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{     0.00,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.860776,       0.0,-0.296480,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.002525,  1.851800, 1.000400, 1.007900,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{     0.00,      0.00,      0.0,-5.255200, 2.511800, 0.047000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.370762,  1.003566,      0.0,      0.0,-0.043000,-0.043000,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6         7          8        9         10         11       12        13       14        15     */
{ /* index 5, FSP type = 0 */
5, CONIFER, "FSP",
{-1.199080,  1.100526, 1.288839,-0.922070,-0.818310,-1.391490,-0.355320,      0.0,     0.00,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.699420,  0.043976,      0.0, 0.829439,-0.0011046,0.679657,     0.00,-1.438710,-0.296890, 0.276500,-0.172840,-0.183940, 0.090011, 0.000000, 0.000000, 0.000000},
{ 0.351351,  0.105800, 0.725620,      0.0, 0.309350, 2.865400,-1.425800,-3.017700,-1.716000,-1.145200,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.710037,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.243019,  0.523308, 0.744742,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 4.660100,  1.070400,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.612946,  0.505017, 0.449370,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.056619,  0.876059,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 6.588040, -5.505680,-0.321050,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.860776,       0.0,-0.296480,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.002377,  1.987190, 0.937400, 1.003460,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,-4.023000, 2.032700,-7.637000, 3.364800,-3.984000, 2.666700, 0.000000, 0.000000, 0.000000, 0.000000},
{ 1.116354,  1.008912,-0.309110,-0.039020,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15    */
{ /* index 6, FTO type = 1 */
6, HARDWOOD, "FTO",
{-1.911680,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0,  0.41500,-0.400000,-0.400000, 0.071864, 0.000000, 0.000000, 0.000000},
{ 0.297760,  0.087780,      0.0, 0.469220,      0.0, 6.874500,-5.240300,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.698931,       1.0, 0.623570,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.940452,  0.507503, 1.093544,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 4.444300,  1.704000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.757731,  0.674815, 0.219771,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.252449,  0.820175,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 6.394860, -4.522690,-0.235301,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.226985,  0.551898,-0.022798,-0.085937,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.846010,       0.0,-0.923390,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.005887,  1.941650, 0.865620,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.278000,-0.019000, 0.000000, 0.000000},
{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 7, FWF type = 0 */
7, CONIFER, "FWF",
{-1.654340,  1.163265, 1.288839,-0.922070,-1.006830,-1.391490,-0.355320,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.290810,  0.043976,      0.0, 1.115251,-0.0110465,0.679657,     0.00,-1.438710,-0.296890, 0.276500, -0.23262, -0.18394, 0.090011, 0.000000, 0.000000, 0.000000},
{ 0.040760,  0.134570, 0.131410, 1.179880, 1.579620, 2.535800,-0.944900,-0.844000,-0.080500,-0.080500,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.952367,  0.926947,     0.00,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.326070,  0.130851, 1.356726,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 6.188000,  1.006900,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.747542,  0.672840, 0.304861,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.035019,  1.003319,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 6.749740, -5.498230,-0.327093,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.795211,       0.0,-0.310294,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.001788,  1.928900, 1.065300, 0.999710,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,-3.466200, 1.927800,-4.828700, 2.558500,-3.738900, 2.682500, 0.000000, 0.000000, 0.000000, 0.000000},
{ 1.176471,  1.008912,-0.309110,-0.039020,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 8, FGC type = 1 */
8, HARDWOOD, "FGC",
{-1.502670,  1.009852, 0.143539,-0.082500,-0.970760,-0.208320,-0.465560, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.873080,  0.034321, 0.000000, 0.776911,-0.012880, 0.000000,-0.278670, 0.000000,      0.0, 0.415000,-0.400000,-0.400000, 0.071864, 0.000000, 0.000000, 0.000000},
{ 0.129790,  0.109710, 0.000000, 0.000000, 1.369050, 4.405700,-0.160000,-3.070400,-2.858400,-2.858400, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.766406,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0},
{-0.088500,  0.534001, 1.742941, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 2.979400,  1.551200,-0.014161, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.847383,  0.791405, 0.236346, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.321091,  1.028420, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{14.192200,-12.649500,-0.087757, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.500483,  1.859937,-0.166023,-0.274213, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.752273,  0.000000,-0.343339, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.005521,  2.072020, 0.774670, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 3.278000,-0.019000, 0.000000},
{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 9, FOO type = 1 */
9, HARDWOOD, "FOO",
{-1.911680,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0,  0.41500,-0.400000,-0.400000, 0.071864, 0.000000, 0.000000, 0.000000},
{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.724108,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.205640,  0.332842, 1.320422,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.078600,  1.924200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.768264,  0.555826, 0.160599,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.991461,  0.801498,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 4.435520, -3.300560,-0.649916,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.206178,  0.910631,-0.038421,-0.254271,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.846010,       0.0,-0.923390,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.0024277, 2.255750, 0.871080, 1.000000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.278000,-0.019000, 0.000000, 0.000000},
{ 0.880678,  1.030668,-0.122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15  */
{ /* index 10, FPM type = 1 */
10, HARDWOOD, "FPM",
{-1.576230,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.737760,  0.034321,      0.0, 1.039708,-0.012880,      0.0,-0.278670,      0.0,      0.0, 0.415000,-0.400000,-0.400000, 0.071864, 0.000000, 0.000000, 0.000000},
{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.778028,       1.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 1.467927,  0.705907, 0.348202,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.429900,  1.353200,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.804766,  0.591219, 0.151474,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.607344,  1.156704,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 5.981730, -4.203110,-0.295019,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.194959,  0.261376, 0.011321,-0.150284,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.709393,       0.0,-0.319237,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.0067323, 1.96628,  0.834580, 1.000000,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{      0.0,       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 3.119000,-2.284000, 0.000000, 0.000000},
{ 0.880678,  1.030668,-.0122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15    */
{ /* index 11, FRA type = 1 */
11, HARDWOOD, "FRA",
{-1.576230,  1.009852, 0.143539,-0.082500,-0.796930,-0.208320,-0.465560,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.559060,  0.034321,      0.0, 1.281572,-0.012880,      0.0,-0.278670,      0.0,      0.0, 0.415000,-0.400000,-0.400000, 0.071864, 0.000000, 0.000000, 0.000000},
{ 0.314924,  0.155572,      0.0,      0.0,      0.0, 6.049900,-4.864300,-1.264200,-2.193800, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.773450,  1.000000, 0.000000,      0.0, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.254510,  0.738367, 0.572465, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.078600,  1.924200, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.547466,  0.442687, 1.043825, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.252449,  0.820175, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.156310, -0.732900,-1.263280, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.709393,  0.000000,-0.319237, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.007269,  2.143200, 0.742200, 1.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 3.278000,-0.019000, 0.000000, 0.000000},
{ 0.880678,  1.030668,-.0122800,-0.506270,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9        10       11       12        13       14        15    */
{ /* index 12, FMZ type = 2 */
12, SHRUB, "FMZ",
{ 0.052777, 0.046057, 0.000000, 0.091103, 0.004174, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.376316,-3.461019, 1.677419,-0.099159, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.702099, 0.617866, 1.325870, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.067437, 0.748448, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.528185, 0.891697,-0.067543,-0.121772, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-5.48680,  2.692500, 0.018000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.100000, 0.949400,-0.562100,-1.101110, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15 */
{ /* index 13, FDB type = 2 */
13, SHRUB, "FDB",
{ 0.034687, 0.029844, 0.008261, 0.045849, 0.002756, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,-0.537715,-0.168269, 0.000000,-0.189138, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 1.089729, 0.747993, 1.097979, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.111103, 0.522718, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.408897, 0.677987,-0.036506,-0.123289, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-7.17520,  2.852000, 0.078000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.100000, 0.949400,-0.562100,-1.101110, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15 */
{ /* index 14, FSB type = 2 */
14, SHRUB, "FSB",
{ 0.133358,  0.074102, 0.000000, 0.024693, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, -1.379933, 1.060711,-0.059576, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.222940,  0.637520, 1.623455, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.958757,  0.536006, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.616536,  0.154475,-0.001578,-0.103090, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-6.909900,  2.845200, 0.078000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.100000, 0.949400,-0.562100,-1.101110, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15   */
{ /* index 15, FRF type = 0 */
15, CONIFER, "FRF",
{-1.654340,  1.163265, 1.288839,-0.922070,-1.006830,-1.391490,-0.355320,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-2.290810,  0.043976,      0.0, 1.115251,-0.0110465,0.679657,     0.00,-1.438710,-0.296890, 0.276500, -0.23262, -0.18394, 0.090011, 0.000000, 0.000000, 0.000000},
{ 0.040760,  0.134570, 0.131410, 1.179880, 1.579620, 2.535800,-0.944900,-0.844000,-0.080500,-0.080500, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.952367,  0.926947,     0.00,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
{-0.326070,  0.130851, 1.356726, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 3.088400,  0.787100, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.747542,  0.672840, 0.304861, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{-1.035019,  1.003319, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 6.749740, -5.498230,-0.327093, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.795211,  0.000000,-0.310294, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.001195,  1.870200, 1.203400, 0.997480, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000,  0.000000, 0.000000, 0.000000, 0.000000, 0.000000,-3.466200, 1.927800,-4.828700, 2.558500, -3.73890, 2.682500, 0.000000, 0.000000, 0.000000, 0.000000},
{ 1.176471,  1.008912,-0.309110,-0.039020,      0.0,      0.0,      0.0, 0.100000,      0.0,      0.0,      0.0,      0.0, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15   */
{ /* index 16, FNS type = 4 */
16, NON_STOCKED, "FNS",
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15   */
{ /* index 17, FUN type = 2 This is for unknown shrubs with zero growth, like CEPR */
17, SHRUB, "FUN",
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000 },
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
},

/*   0          1         2         3          4         5         6          7          8        9         10         11       12        13       14        15 */
{ /* index 18, FUN type = 3 */
18, FORB, "FRB",
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
{ 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000},
}

};





/* this function allocates an array of n_coeffs records     */
/* which is the array that will be returned. the function   */
/* then copies the local coeffs into that array and the     */
/* returns                                                  */
struct COEFFS_RECORD *con_swo_init_coeffs( 
   unsigned long               *n_coeffs, 
   double                       *coeffs_version )
{

   struct COEFFS_RECORD *temp_coeffs; 
   
   /* these are defined by the model */
    *n_coeffs       = N_SWO_CONIFERS_COEFFS;
    *coeffs_version = (double)CURRENT_COEFFS_VER;

    /* if you want to return the coeffs version for this    */
    /* variant you might want to return it here             */
    
   temp_coeffs = (struct COEFFS_RECORD *)calloc( 
      *n_coeffs, sizeof( struct COEFFS_RECORD ) );
   
   memcpy( temp_coeffs, swo_temp_coeffs, sizeof( swo_temp_coeffs ) );
   
   return temp_coeffs;
}

