% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trollsim.R
\docType{class}
\name{trollsim-class}
\alias{trollsim-class}
\title{A \code{TROLL} simulations}
\value{
An empty S4 \code{\link[=trollsim]{trollsim()}} class object.
}
\description{
\code{trollsim()} is an S4 class to represent a \code{TROLL} simulation. \code{trollsim}
values can be accessed using object attributes in the form of simple R
objects (with \code{@}). They consist of eight simulation attributes: (1) name,
(2) path to saved files, (3) parameters, (4) inputs, (5) log, (6) initial and
final state, (7) ecosystem output metrics, and (8) species output metrics.
The initial and final states are represented by a table with the spatial
position, size and other relevant traits of all trees at the start and end of
the simulation. The ecosystem and species metrics are summaries of ecosystem
processes and states, such as net primary production and aboveground biomass,
and they are documented at species level and aggregated over the entire
stand.
}
\section{Slots}{

\describe{
\item{\code{name}}{char. Simulation name.}

\item{\code{path}}{char. File path to the simulation.}

\item{\code{mem}}{bool. Is the simulation in memory, see \code{\link[=load_sim]{load_sim()}}.}

\item{\code{parameters}}{numeric. Parameters of the simulation (general inputs).}

\item{\code{inputs}}{list. Simulation inputs (species, climate, daily, forest, lidar,
see \code{\link[=stack]{stack()}}).}

\item{\code{log}}{chr. Simulation log, see \code{\link[=get_log]{get_log()}}.}

\item{\code{forest}}{df. Simulation initial and final forest, see \code{\link[=get_forest]{get_forest()}}.}

\item{\code{ecosystem}}{df. Ecosystem metrics.}

\item{\code{species}}{df. Species metrics (with OUTPUT_extended option, see
\code{\link[=generate_parameters]{generate_parameters()}}).}

\item{\code{las}}{list. List with simulated point cloud in LAS from lidar parameters
(with lidar option, see \code{\link[=generate_lidar]{generate_lidar()}}). The LAS format correspond to
\code{\link[lidR:LAS-class]{lidR::LAS()}}.}
}}

\seealso{
\code{\link[=troll]{troll()}}, \code{\link[=load_output]{load_output()}}, \code{\link[=trollstack]{trollstack()}}
}
