% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pmid2doi}
\alias{doi2pmid}
\alias{pmid2doi}
\title{Get a PMID from a DOI, and vice versa.}
\usage{
pmid2doi(x, simplify = FALSE, ...)

doi2pmid(x, simplify = FALSE, ...)
}
\arguments{
\item{x}{(character) One or more DOIs or PMIDs}

\item{simplify}{(logical) Whether to simplify result to vector.}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}.}
}
\description{
Get a PMID from a DOI, and vice versa.
}
\examples{
\donttest{
# dois to pmids
doi2pmid("10.1016/0006-2944(75)90147-7")
doi2pmid("10.1016/0006-2944(75)90147-7", TRUE)
doi2pmid(c("10.1016/0006-2944(75)90147-7","10.1186/gb-2008-9-5-r89"))

# pmids to dois
pmid2doi(18507872)
pmid2doi(18507872, TRUE)
pmid2doi(c(1,2,3))

library('httr')
pmid2doi(18507872, config=verbose())
}
}
\references{
Uses the \url{http://www.pmid2doi.org/} REST API.
}

