% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependability.R
\name{subkoviak}
\alias{subkoviak}
\title{Calculate Subkoviak's (1988) single administration consistency indices}
\usage{
subkoviak(data, items, raw_cut_score, total = NULL, look_up = FALSE)
}
\arguments{
\item{data}{A data frame of dichotomously scored test items}

\item{items}{Raw column indices representing the test items or 
number of items on the test (see Details)}

\item{raw_cut_score}{The raw cut-score for the test}

\item{total}{Total score column of the test (see Details)}

\item{look_up}{If TRUE, the agreement and kappa tables from Subkoviak (1988) are returned with the results}
}
\value{
The \code{z_cut} score and the rounded \code{z_cut_rounded} score for the test

The estimated alpha coefficient. K-R21 is used when there is no item-level information.
Otherwise, K-R20 is used.

The rounded values for the \code{agree_coef} (agreement) and \code{kappa_coef} (kappa) coefficients from Subkoviak's (1988) tables
}
\description{
Calculate Subkoviak's (1988) single administration consistency indices
}
\details{
When the item-level information is available, Kuder-Richardson 20 is used
as an estimate of alpha. If only the total scores on the test are available and the
number of items is known, Kuder-Richardson 21 is used as an estimate of alpha.
}
\examples{
subkoviak(data = bh_depend, items = 2:31, raw_cut_score = 21)
}
