% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdbwdensity.R
\name{rdbwdensity}
\alias{rdbwdensity}
\title{Bandwidth Selection for Manipulation Testing Using Local Polynomial Density Estimation}
\usage{
rdbwdensity(X, c = 0, p = 2, kernel = "", fitselect = "",
  vce = "")
}
\arguments{
\item{X}{Numeric vector or one dimensional matrix / data frame, the running variable.}

\item{c}{Numeric, specifies the threshold or cutoff value in the support of \code{X},
which determes the two samples (e.g., control and treatment units in RD settings).  Default
is \code{0}.}

\item{p}{Integer, specifies the order of the local-polynomial used to construct the density
point estimators.  Default is \code{2} (local quadratic approximation).}

\item{kernel}{String, specifies the kernel function used to construct the local-polynomial
estimator(s). Options are: \code{"triangular"}, \code{"epanechnikov"}, and \code{"uniform"}. Default is
\code{"triangular"}.}

\item{fitselect}{String, specifies whether restrictions should be imposed. Options are:
\code{"unrestricted"} for density estimation without any restrictions (two-sample, unrestricted
inference). This is the default option. \code{"restricted"} for density estimation assuming
equal c.d.f. and higher-order derivatives.}

\item{vce}{String, specifies the procedure used to compute the variance-covariance matrix estimator. Options are:
\code{"plugin"} for asymptotic plug-in standard errors. \code{"jackknife"} for jackknife standard errors. This
is the default option.}
}
\value{
\item{h}{Bandwidths for density discontinuity test, left and right to the cutoff, and asymptotic variance and bias.}
\item{N}{\code{full}: full sample size; \code{left}/\code{right}: sample size to the left/right of the cutoff.}
\item{opt}{Collects the options used, includes: \code{fitselect}, \code{kernel},
  \code{vce}, \code{c}, \code{p}. See options for \code{rdbwdensity}.}
\item{X_min}{Smallest observations to the left and right of the cutoff.}
\item{X_max}{Largest observations to the left and right of the cutoff.}
}
\description{
\code{rdbwdensity} implements several data-driven bandwidth selection methods
  for the manipulation testing procedure of Cattaneo, Jansson and Ma (2019).

Companion command: \code{\link{rddensity}} for density discontinuity (manipulation)
  testing. A companion \code{Stata} package is described in Cattaneo, Jansson and Ma (2018).

Related Stata and R packages useful for inference in regression discontinuity (RD)
  designs are described at \url{https://sites.google.com/site/rdpackages}.
}
\examples{
# Generate a random sample
set.seed(42); x <- rnorm(2000, mean = -0.5)

# Construct bandwidth
summary(rdbwdensity(X = x, vce="jackknife"))

}
\references{
M.D. Cattaneo, M. Jansson and X. Ma. (2018). \href{https://sites.google.com/site/rdpackages/rddensity/Cattaneo-Jansson-Ma_2018_Stata.pdf}{Manipulation Testing based on Density Discontinuity}.  \emph{Stata Journal} 18(1): 234-261.

M.D. Cattaneo, M. Jansson and X. Ma. (2019).  \href{https://arxiv.org/abs/1811.11512}{Simple Local Polynomial Density Estimators}. \emph{Journal of the American Statistical Association}, forthcoming.
}
\seealso{
\code{\link{rddensity}}
}
\author{
Matias D. Cattaneo, Princeton University  \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley.  \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
