% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph.R
\docType{class}
\name{Graph}
\alias{Graph}
\title{An undirected graph}
\description{
An R6 class to represent a graph (from discrete mathematics).
}
\details{
Encapsulates and provides methods for computation and checking of 
undirected graphs. Graphs are systems of vertices connected in pairs by 
edges. A base class.
}
\references{
{ 
  Gansner ER, Koutsofios E, North SC, Vo K-P. A technique for drawing
  directed graphs. \emph{IEEE Transactions on Software Engineering},
  1993;\bold{19}:214–30, \doi{10.1109/32.221135}.

  Gross JL, Yellen J, Zhang P. Handbook of Graph Theory. Second edition, 
  Chapman and Hall/CRC.; 2013, \doi{10.1201/b16132}
}
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Graph$new()}}
\item \href{#method-vertex_index}{\code{Graph$vertex_index()}}
\item \href{#method-has_vertex}{\code{Graph$has_vertex()}}
\item \href{#method-edge_index}{\code{Graph$edge_index()}}
\item \href{#method-has_edge}{\code{Graph$has_edge()}}
\item \href{#method-order}{\code{Graph$order()}}
\item \href{#method-size}{\code{Graph$size()}}
\item \href{#method-graph_adjacency_matrix}{\code{Graph$graph_adjacency_matrix()}}
\item \href{#method-is_simple}{\code{Graph$is_simple()}}
\item \href{#method-is_connected}{\code{Graph$is_connected()}}
\item \href{#method-is_acyclic}{\code{Graph$is_acyclic()}}
\item \href{#method-is_tree}{\code{Graph$is_tree()}}
\item \href{#method-degree}{\code{Graph$degree()}}
\item \href{#method-neighbours}{\code{Graph$neighbours()}}
\item \href{#method-as_DOT}{\code{Graph$as_DOT()}}
\item \href{#method-clone}{\code{Graph$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Graph} object from sets of nodes 
and edges.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$new(V, E)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{V}}{A list of Nodes.}

\item{\code{E}}{A list of Edges.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Graph} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vertex_index"></a>}}
\if{latex}{\out{\hypertarget{method-vertex_index}{}}}
\subsection{Method \code{vertex_index()}}{
Find the index of a vertex in the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$vertex_index(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{Subject vertex}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Index of \code{v}. The vertexes are normally stored in the same
order they are specified in \code{new}, but this cannot be guaranteed. 
This' function returns the same index as used in the adjacency matrix and 
\code{NA} if the vertex is not in the graph.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_vertex"></a>}}
\if{latex}{\out{\hypertarget{method-has_vertex}{}}}
\subsection{Method \code{has_vertex()}}{
Test whether a vertex is an element of the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$has_vertex(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{Subject vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if v is an element of V(G).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-edge_index"></a>}}
\if{latex}{\out{\hypertarget{method-edge_index}{}}}
\subsection{Method \code{edge_index()}}{
Find the index of an edge in a graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$edge_index(e)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{Subject edge.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Index of \code{e}. The edges are normally stored in the same order
they are specified in \code{new}, but this cannot be guaranteed. This
function returns the same index returned in other functions and \code{NA}
if the edge is not in the graph.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_edge"></a>}}
\if{latex}{\out{\hypertarget{method-has_edge}{}}}
\subsection{Method \code{has_edge()}}{
Test whether an edge is element of the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$has_edge(e)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{Subject edge.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if \code{e} is an element of \eqn{E(G)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-order"></a>}}
\if{latex}{\out{\hypertarget{method-order}{}}}
\subsection{Method \code{order()}}{
Return the order of the graph (number of vertices).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$order()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Order of the graph (integer).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Return the size of the graph (number of edges).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Size of the graph (integer).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph_adjacency_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-graph_adjacency_matrix}{}}}
\subsection{Method \code{graph_adjacency_matrix()}}{
Compute the adjacency matrix for the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$graph_adjacency_matrix(boolean = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{boolean}}{If \code{TRUE}, the adjacency matrix is logical, each
cell is {\code{FALSE},\code{TRUE}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Each cell contains the
number of edges joining the two vertexes, with the convention of
self loops being counted twice, unless \code{binary} is \code{TRUE} when
cells are either 0 (not adjacent) or 1 (adjacent).
}

\subsection{Returns}{
A square numeric matrix with the number of rows and columns
equal to the order of the graph. The rows and columns are in the
same order as \code{V}. If the nodes have defined and unique labels the
\code{dimnames} of the matrix are the labels of the nodes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_simple"></a>}}
\if{latex}{\out{\hypertarget{method-is_simple}{}}}
\subsection{Method \code{is_simple()}}{
Is this a simple graph?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$is_simple()}\if{html}{\out{</div>}}
}

\subsection{Details}{
A simple graph has no self loops or multi-edges.
}

\subsection{Returns}{
\code{TRUE} if simple, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_connected"></a>}}
\if{latex}{\out{\hypertarget{method-is_connected}{}}}
\subsection{Method \code{is_connected()}}{
Test whether the graph is connected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$is_connected()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Graphs with no vertices are considered unconnected; graphs with
1 vertex are considered connected. Otherwise a graph is connected if all 
nodes can be reached from an arbitrary starting point. Uses a depth first
search.
}

\subsection{Returns}{
\code{TRUE} if connected, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_acyclic"></a>}}
\if{latex}{\out{\hypertarget{method-is_acyclic}{}}}
\subsection{Method \code{is_acyclic()}}{
Checks for the presence of a cycle in the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$is_acyclic()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Uses a depth-first search from each node to detect the
presence of back edges. A back edge is an edge from the current node
joining a previously detected (visited) node, that is not the parent 
node of the current one.
}

\subsection{Returns}{
\code{TRUE} if no cycles detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_tree"></a>}}
\if{latex}{\out{\hypertarget{method-is_tree}{}}}
\subsection{Method \code{is_tree()}}{
Compute whether the graph is connected and acyclic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$is_tree()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the graph is a tree; \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-degree"></a>}}
\if{latex}{\out{\hypertarget{method-degree}{}}}
\subsection{Method \code{degree()}}{
The degree of a vertex in the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$degree(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{The subject node.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The number of incident edges.
}

\subsection{Returns}{
Degree of the vertex, integer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-neighbours"></a>}}
\if{latex}{\out{\hypertarget{method-neighbours}{}}}
\subsection{Method \code{neighbours()}}{
Find the neighbours of a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$neighbours(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{The subject node.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A property of the graph, not the node. Does not include self, 
even in the case of a loop to self.
}

\subsection{Returns}{
A list of nodes which are joined to the subject.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-as_DOT"></a>}}
\if{latex}{\out{\hypertarget{method-as_DOT}{}}}
\subsection{Method \code{as_DOT()}}{
Export a representation of the graph in DOT format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$as_DOT()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Writes the representation in the \code{graphviz} DOT language
(\url{http://graphviz.org/doc/info/lang.html}) for drawing with one
of the \code{graphviz} tools including \code{dot} (Gansner, 1993).
}

\subsection{Returns}{
A character vector. Intended for passing to \code{writeLines}
for saving as a text file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Graph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
